/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.auth.oauth.definition.OIDCClaimScopeDefinition;
import org.iplass.mtp.auth.oauth.definition.ScopeDefinition;
import org.iplass.mtp.impl.auth.oauth.MetaOIDCClaimScope;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;

@XmlSeeAlso(value={MetaOIDCClaimScope.class})
public class MetaScope
implements MetaData {
    private static final long serialVersionUID = -4509688467517539934L;
    private String name;
    private String displayName;
    private String description;
    private List<MetaLocalizedString> localizedDisplayNameList;
    private List<MetaLocalizedString> localizedDescriptionList;

    public MetaScope() {
    }

    public MetaScope(String name, String displayName, String description) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<MetaLocalizedString> getLocalizedDisplayNameList() {
        return this.localizedDisplayNameList;
    }

    public void setLocalizedDisplayNameList(List<MetaLocalizedString> localizedDisplayNameList) {
        this.localizedDisplayNameList = localizedDisplayNameList;
    }

    public List<MetaLocalizedString> getLocalizedDescriptionList() {
        return this.localizedDescriptionList;
    }

    public void setLocalizedDescriptionList(List<MetaLocalizedString> localizedDescriptionList) {
        this.localizedDescriptionList = localizedDescriptionList;
    }

    public MetaScope copy() {
        return (MetaScope)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public static MetaScope createInstance(ScopeDefinition definition) {
        if (definition instanceof OIDCClaimScopeDefinition) {
            return new MetaOIDCClaimScope();
        }
        if (definition instanceof ScopeDefinition) {
            return new MetaScope();
        }
        return null;
    }

    public void applyConfig(ScopeDefinition def) {
        this.name = def.getName();
        this.displayName = def.getDisplayName();
        this.description = def.getDescription();
        this.localizedDisplayNameList = I18nUtil.toMeta(def.getLocalizedDisplayNameList());
        this.localizedDescriptionList = I18nUtil.toMeta(def.getLocalizedDescriptionList());
    }

    public ScopeDefinition currentConfig() {
        ScopeDefinition def = new ScopeDefinition();
        this.fill(def);
        return def;
    }

    protected void fill(ScopeDefinition def) {
        def.setName(this.name);
        def.setDisplayName(this.displayName);
        def.setDescription(this.description);
        def.setLocalizedDisplayNameList(I18nUtil.toDef(this.localizedDisplayNameList));
        def.setLocalizedDescriptionList(I18nUtil.toDef(this.localizedDescriptionList));
    }
}

