/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.oauth.definition.CustomTokenIntrospectorDefinition;
import org.iplass.mtp.auth.oauth.definition.OAuthResourceServerDefinition;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.oauth.MetaCustomTokenIntrospector;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.OAuthClientCredentialHandler;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaOAuthResourceServer
extends BaseRootMetaData
implements DefinableMetaData<OAuthResourceServerDefinition> {
    private static final long serialVersionUID = 1339189788049685788L;
    private static Logger logger = LoggerFactory.getLogger(MetaOAuthResourceServer.class);
    private List<MetaCustomTokenIntrospector> customTokenIntrospectors;

    public List<MetaCustomTokenIntrospector> getCustomTokenIntrospectors() {
        return this.customTokenIntrospectors;
    }

    public void setCustomTokenIntrospectors(List<MetaCustomTokenIntrospector> customTokenIntrospectors) {
        this.customTokenIntrospectors = customTokenIntrospectors;
    }

    public void applyConfig(OAuthResourceServerDefinition def) {
        this.name = def.getName();
        this.description = def.getDescription();
        this.displayName = def.getDisplayName();
        if (def.getCustomTokenIntrospectors() != null) {
            this.customTokenIntrospectors = new ArrayList<MetaCustomTokenIntrospector>();
            for (CustomTokenIntrospectorDefinition d : def.getCustomTokenIntrospectors()) {
                MetaCustomTokenIntrospector m = MetaCustomTokenIntrospector.createInstance(d);
                m.applyConfig(d);
                this.customTokenIntrospectors.add(m);
            }
        } else {
            this.customTokenIntrospectors = null;
        }
    }

    public OAuthResourceServerDefinition currentConfig() {
        OAuthResourceServerDefinition def = new OAuthResourceServerDefinition();
        def.setName(this.name);
        def.setDescription(this.description);
        def.setDisplayName(this.displayName);
        if (this.customTokenIntrospectors != null) {
            def.setCustomTokenIntrospectors(new ArrayList<CustomTokenIntrospectorDefinition>());
            for (MetaCustomTokenIntrospector m : this.customTokenIntrospectors) {
                def.getCustomTokenIntrospectors().add(m.currentConfig());
            }
        }
        return def;
    }

    public MetaOAuthResourceServer copy() {
        return (MetaOAuthResourceServer)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public OAuthResourceServerRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new OAuthResourceServerRuntime();
    }

    public class OAuthResourceServerRuntime
    extends BaseMetaDataRuntime {
        private OAuthClientCredentialHandler ch = (OAuthClientCredentialHandler)((AuthTokenService)ServiceRegistry.getRegistry().getService(AuthTokenService.class)).getHandler("ORS");
        private List<MetaCustomTokenIntrospector.CustomTokenIntrospectorRuntime> customTokenIntrospectorRuntimes;

        private OAuthResourceServerRuntime() {
            try {
                if (MetaOAuthResourceServer.this.customTokenIntrospectors != null) {
                    this.customTokenIntrospectorRuntimes = new ArrayList<MetaCustomTokenIntrospector.CustomTokenIntrospectorRuntime>();
                    for (int i = 0; i < MetaOAuthResourceServer.this.customTokenIntrospectors.size(); ++i) {
                        this.customTokenIntrospectorRuntimes.add(((MetaCustomTokenIntrospector)MetaOAuthResourceServer.this.customTokenIntrospectors.get(i)).createRuntime(MetaOAuthResourceServer.this.getId(), i));
                    }
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public MetaOAuthResourceServer getMetaData() {
            return MetaOAuthResourceServer.this;
        }

        public Credential generateCredential() {
            return this.ch.generateCredential(MetaOAuthResourceServer.this.getName());
        }

        public boolean validateCredential(Credential cre) {
            return this.ch.validateCredential(cre, MetaOAuthResourceServer.this.getName());
        }

        public void deleteOldCredential() {
            this.ch.deleteOldCredential(MetaOAuthResourceServer.this.getName());
        }

        public Map<String, Object> toResponseMap(RequestContext request, AccessToken accessToken, MetaOAuthAuthorization.OAuthAuthorizationRuntime authServer) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("active", true);
            res.put("token_type", "Bearer");
            if (accessToken.getGrantedScopes() != null) {
                res.put("scope", String.join((CharSequence)" ", accessToken.getGrantedScopes()));
            }
            res.put("client_id", accessToken.getClientId());
            res.put("username", accessToken.getUser().getName());
            res.put("sub", accessToken.getUser().getOid());
            res.put("exp", accessToken.getExpirationTime());
            res.put("iat", accessToken.getIssuedAt());
            res.put("nbf", accessToken.getNotBefore());
            res.put("aud", MetaOAuthResourceServer.this.getName());
            res.put("iss", authServer.issuerId(request));
            if (MetaOAuthResourceServer.this.customTokenIntrospectors != null) {
                for (MetaCustomTokenIntrospector.CustomTokenIntrospectorRuntime ctir : this.customTokenIntrospectorRuntimes) {
                    if (ctir.handle(res, request, accessToken)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("ResourceServer:" + MetaOAuthResourceServer.this.getName() + "'s " + ctir.getMetaData() + " handle fail. accessToken:" + res);
                    }
                    return null;
                }
            }
            return res;
        }
    }
}

