/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.oauth.definition.ClientPolicyDefinition;
import org.iplass.mtp.auth.oauth.definition.ClientType;
import org.iplass.mtp.auth.oauth.definition.GrantType;
import org.iplass.mtp.auth.oauth.definition.OAuthAuthorizationDefinition;
import org.iplass.mtp.auth.oauth.definition.ScopeDefinition;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.oauth.MetaClientPolicy;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.MetaOIDCClaimScope;
import org.iplass.mtp.impl.auth.oauth.MetaScope;
import org.iplass.mtp.impl.auth.oauth.MetaSubjectIdentifierType;
import org.iplass.mtp.impl.auth.oauth.OAuthApplicationException;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.OAuthClientService;
import org.iplass.mtp.impl.auth.oauth.OAuthRuntimeException;
import org.iplass.mtp.impl.auth.oauth.OAuthTokens;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationCode;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationRequest;
import org.iplass.mtp.impl.auth.oauth.idtoken.IdToken;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.auth.oauth.token.RefreshToken;
import org.iplass.mtp.impl.auth.oauth.util.OAuthUtil;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.web.template.TemplateUtil;

public class MetaOAuthAuthorization
extends BaseRootMetaData
implements DefinableMetaData<OAuthAuthorizationDefinition> {
    private static final long serialVersionUID = 3413613829144055452L;
    private static List<MetaScope> standardScopes = new ArrayList<MetaScope>();
    private List<String> availableRoles;
    private List<MetaScope> scopes;
    private String consentTemplateName;
    private List<MetaClientPolicy> clientPolicies;
    private MetaSubjectIdentifierType subjectIdentifierType;
    private String issuerUri;

    public String getIssuerUri() {
        return this.issuerUri;
    }

    public void setIssuerUri(String issuerUri) {
        this.issuerUri = issuerUri;
    }

    public MetaSubjectIdentifierType getSubjectIdentifierType() {
        return this.subjectIdentifierType;
    }

    public void setSubjectIdentifierType(MetaSubjectIdentifierType subjectIdentifierType) {
        this.subjectIdentifierType = subjectIdentifierType;
    }

    public List<MetaClientPolicy> getClientPolicies() {
        return this.clientPolicies;
    }

    public void setClientPolicies(List<MetaClientPolicy> clientPolicies) {
        this.clientPolicies = clientPolicies;
    }

    public List<String> getAvailableRoles() {
        return this.availableRoles;
    }

    public void setAvailableRoles(List<String> availableRoles) {
        this.availableRoles = availableRoles;
    }

    public String getConsentTemplateName() {
        return this.consentTemplateName;
    }

    public void setConsentTemplateName(String consentTemplateName) {
        this.consentTemplateName = consentTemplateName;
    }

    public List<MetaScope> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<MetaScope> scopes) {
        this.scopes = scopes;
    }

    public OAuthAuthorizationRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new OAuthAuthorizationRuntime();
    }

    public MetaOAuthAuthorization copy() {
        return (MetaOAuthAuthorization)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public void applyConfig(OAuthAuthorizationDefinition def) {
        this.name = def.getName();
        this.description = def.getDescription();
        this.displayName = def.getDisplayName();
        this.availableRoles = def.getAvailableRoles() != null ? new ArrayList<String>(def.getAvailableRoles()) : null;
        if (def.getScopes() != null) {
            this.scopes = new ArrayList<MetaScope>();
            for (ScopeDefinition sd : def.getScopes()) {
                MetaScope ms = MetaScope.createInstance(sd);
                ms.applyConfig(sd);
                this.scopes.add(ms);
            }
        } else {
            this.scopes = null;
        }
        this.consentTemplateName = def.getConsentTemplateName();
        if (def.getClientPolicies() != null) {
            this.clientPolicies = new ArrayList<MetaClientPolicy>();
            for (ClientPolicyDefinition cpd : def.getClientPolicies()) {
                MetaClientPolicy mcp = new MetaClientPolicy();
                mcp.applyConfig(cpd);
                this.clientPolicies.add(mcp);
            }
        } else {
            this.clientPolicies = null;
        }
        if (def.getSubjectIdentifierType() != null) {
            this.subjectIdentifierType = MetaSubjectIdentifierType.createInstance(def.getSubjectIdentifierType());
            this.subjectIdentifierType.applyConfig(def.getSubjectIdentifierType());
        } else {
            this.subjectIdentifierType = null;
        }
        this.issuerUri = def.getIssuerUri();
    }

    public OAuthAuthorizationDefinition currentConfig() {
        ArrayList<ScopeDefinition> list;
        OAuthAuthorizationDefinition def = new OAuthAuthorizationDefinition();
        def.setName(this.name);
        def.setDescription(this.description);
        def.setDisplayName(this.displayName);
        if (this.availableRoles != null) {
            def.setAvailableRoles(new ArrayList<String>(this.availableRoles));
        }
        if (this.scopes != null) {
            list = new ArrayList<ScopeDefinition>();
            for (MetaScope ms : this.scopes) {
                list.add(ms.currentConfig());
            }
            def.setScopes(list);
        }
        def.setConsentTemplateName(this.consentTemplateName);
        if (this.clientPolicies != null) {
            list = new ArrayList();
            for (MetaClientPolicy mcp : this.clientPolicies) {
                list.add((ScopeDefinition)((Object)mcp.currentConfig()));
            }
            def.setClientPolicies(list);
        }
        if (this.subjectIdentifierType != null) {
            def.setSubjectIdentifierType(this.subjectIdentifierType.currentConfig());
        }
        def.setIssuerUri(this.issuerUri);
        return def;
    }

    static {
        standardScopes.add(new MetaScope("offline_access", "Offline Access", "Application requres offline access to your resources."));
        standardScopes.add(new MetaScope("openid", "OpenID", "Application requires your public identifier(OpenID)."));
    }

    public class OAuthAuthorizationRuntime
    extends BaseMetaDataRuntime {
        private OAuthAuthorizationService service = (OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class);
        private OAuthClientService clientService = (OAuthClientService)ServiceRegistry.getRegistry().getService(OAuthClientService.class);
        private EnumMap<ClientType, MetaClientPolicy.ClientPolicyRuntime> clientPolicyRuntimeMap;
        private MetaSubjectIdentifierType.SubjectIdentifierTypeRuntime subjectIdentifierTypeRuntime;
        private Map<String, MetaScope> scopeMap;
        private Map<String, MetaOIDCClaimScope.OIDCClaimScopeRuntime> oidcClaimScopeMap;

        private OAuthAuthorizationRuntime() {
            try {
                boolean useOpenIdConnect = false;
                this.clientPolicyRuntimeMap = new EnumMap(ClientType.class);
                if (MetaOAuthAuthorization.this.clientPolicies != null) {
                    for (MetaClientPolicy cp : MetaOAuthAuthorization.this.clientPolicies) {
                        this.clientPolicyRuntimeMap.put(cp.getClientType(), cp.createRuntime(MetaOAuthAuthorization.this));
                        useOpenIdConnect = useOpenIdConnect || cp.isSupportOpenIDConnect();
                    }
                }
                if (MetaOAuthAuthorization.this.subjectIdentifierType == null && useOpenIdConnect) {
                    throw new NullPointerException("subjectIdentifierType must be specified for OpenID Connect");
                }
                if (MetaOAuthAuthorization.this.subjectIdentifierType != null) {
                    this.subjectIdentifierTypeRuntime = MetaOAuthAuthorization.this.subjectIdentifierType.createRuntime();
                }
                this.scopeMap = new HashMap<String, MetaScope>();
                this.oidcClaimScopeMap = new HashMap<String, MetaOIDCClaimScope.OIDCClaimScopeRuntime>();
                if (MetaOAuthAuthorization.this.scopes != null) {
                    for (MetaScope ms : MetaOAuthAuthorization.this.scopes) {
                        this.scopeMap.put(ms.getName(), ms);
                        if (!(ms instanceof MetaOIDCClaimScope)) continue;
                        this.oidcClaimScopeMap.put(ms.getName(), ((MetaOIDCClaimScope)ms).createRuntime(MetaOAuthAuthorization.this.getName()));
                    }
                }
                for (MetaScope ms : standardScopes) {
                    if (this.scopeMap.containsKey(ms.getName())) continue;
                    this.scopeMap.put(ms.getName(), ms);
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public MetaOAuthAuthorization getMetaData() {
            return MetaOAuthAuthorization.this;
        }

        public MetaSubjectIdentifierType.SubjectIdentifierTypeRuntime getSubjectIdentifierType() {
            return this.subjectIdentifierTypeRuntime;
        }

        public void checkValidAuthorizationRequest(AuthorizationRequest authorizationRequest) {
            if (authorizationRequest.getClientId() == null) {
                throw new OAuthApplicationException("invalid_request", "client_id required.");
            }
            MetaOAuthClient.OAuthClientRuntime clientRuntime = (MetaOAuthClient.OAuthClientRuntime)this.clientService.getRuntimeByName(authorizationRequest.getClientId());
            if (clientRuntime == null) {
                throw new IllegalArgumentException("OAuthClient not found:" + authorizationRequest.getClientId());
            }
            if (!clientRuntime.getMetaData().getAuthorizationServerId().equals(MetaOAuthAuthorization.this.getId())) {
                throw new IllegalArgumentException("OAuthClient is not registered to AuthServer:" + authorizationRequest.getClientId());
            }
            if (clientRuntime.getMetaData().getGrantTypes() == null || !clientRuntime.getMetaData().getGrantTypes().contains((Object)GrantType.AUTHORIZATION_CODE)) {
                throw new OAuthApplicationException("unauthorized_client", "grant_type not allowed.");
            }
            if (authorizationRequest.getRedirectUri() == null) {
                throw new OAuthApplicationException("invalid_request", "redirect_uri required.");
            }
            if (authorizationRequest.getResponseTypes() == null || authorizationRequest.getResponseTypes().size() == 0) {
                throw new OAuthApplicationException("invalid_request", "response_type required.");
            }
            for (String rt : authorizationRequest.getResponseTypes()) {
                if ("code".equals(rt)) continue;
                throw new OAuthApplicationException("unsupported_response_type", "invalid response_type.");
            }
            if (authorizationRequest.getScopes() == null || authorizationRequest.getScopes().size() == 0) {
                throw new OAuthApplicationException("invalid_request", "scope required.");
            }
            List<String> scopesByClientType = this.getClientPolicy(clientRuntime.getMetaData().getClientType()).scopeList();
            if (!scopesByClientType.containsAll(authorizationRequest.getScopes())) {
                throw new OAuthApplicationException("invalid_scope", "invalid scope.");
            }
            if (this.service.isParamStateRequired() && authorizationRequest.getState() == null) {
                throw new OAuthApplicationException("invalid_request", "state required.");
            }
            if (this.service.isParamNonceRequired() && authorizationRequest.getNonce() == null) {
                throw new OAuthApplicationException("invalid_request", "nonce required.");
            }
            if (!(authorizationRequest.getResponseMode() == null || "form_post".equals(authorizationRequest.getResponseMode()) || "query".equals(authorizationRequest.getResponseMode()) || "fragment".equals(authorizationRequest.getResponseMode()))) {
                throw new OAuthApplicationException("invalid_request", "invalid response_mode.");
            }
            if (authorizationRequest.getCodeChallenge() == null && authorizationRequest.getCodeChallengeMethod() == null) {
                if (this.service.isForcePKCE() && clientRuntime.getMetaData().getClientType() == ClientType.PUBLIC) {
                    throw new OAuthApplicationException("invalid_request", "PKCE required for public clients.");
                }
            } else {
                if (authorizationRequest.getCodeChallenge() == null) {
                    throw new OAuthApplicationException("invalid_request", "code_challenge required.");
                }
                if (this.service.isForceS256ForCodeChallengeMethod()) {
                    if (!"S256".equals(authorizationRequest.getCodeChallengeMethod())) {
                        throw new OAuthApplicationException("invalid_request", "code_challenge_method only support S256.");
                    }
                } else if (!(authorizationRequest.getCodeChallengeMethod() == null || "S256".equals(authorizationRequest.getCodeChallengeMethod()) && "plain".equals(authorizationRequest.getCodeChallengeMethod()))) {
                    throw new OAuthApplicationException("invalid_request", "invalid code_challenge_method.");
                }
            }
            if (authorizationRequest.getPrompt() != null && authorizationRequest.getPrompt().size() > 0) {
                if (authorizationRequest.getPrompt().contains("none")) {
                    if (authorizationRequest.getPrompt().size() != 1) {
                        throw new OAuthApplicationException("invalid_request", "invalid prompt.");
                    }
                } else {
                    if (authorizationRequest.getPrompt().size() > 2) {
                        throw new OAuthApplicationException("invalid_request", "invalid prompt.");
                    }
                    for (String p : authorizationRequest.getPrompt()) {
                        if (p.equals("consent") || p.equals("login")) continue;
                        throw new OAuthApplicationException("invalid_request", "invalid prompt.");
                    }
                }
            }
            if (authorizationRequest.getMaxAge() != null && authorizationRequest.getMaxAge() < 0L) {
                throw new OAuthApplicationException("invalid_request", "invalid max_age.");
            }
        }

        public MetaClientPolicy.ClientPolicyRuntime getClientPolicy(ClientType clientType) {
            return this.clientPolicyRuntimeMap.get((Object)clientType);
        }

        public List<MetaScope> getScopeByName(List<String> scopeNames) {
            ArrayList<MetaScope> ret = new ArrayList<MetaScope>();
            for (String scopeName : scopeNames) {
                MetaScope ms = this.scopeMap.get(scopeName);
                if (ms == null) continue;
                ret.add(ms);
            }
            return ret;
        }

        public MetaScope getScope(String scopeName) {
            return this.scopeMap.get(scopeName);
        }

        public MetaOIDCClaimScope.OIDCClaimScopeRuntime getOIDCClaimScope(String scopeName) {
            return this.oidcClaimScopeMap.get(scopeName);
        }

        public boolean isNeedConsent(RequestContext request, AuthorizationRequest authReq) {
            MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)this.clientService.getRuntimeByName(authReq.getClientId());
            MetaClientPolicy.ClientPolicyRuntime clientPolicy = this.clientPolicyRuntimeMap.get((Object)client.getMetaData().getClientType());
            AccessToken current = this.service.getAccessTokenStore().getAccessTokenByUserOid(client, AuthContext.getCurrentContext().getUser().getOid());
            return clientPolicy.consentType().needConsent(request, authReq.getScopes(), current);
        }

        public AuthorizationCode generateCode(AuthorizationRequest authReq) {
            AuthContext authContext = AuthContext.getCurrentContext();
            authReq.setUser(authContext.getUser());
            authReq.setAuthTime(authContext.getAuthTime());
            return this.service.getAuthorizationCodeStore().newAuthorizationCode(authReq);
        }

        public String consentTemplateName() {
            if (MetaOAuthAuthorization.this.consentTemplateName != null) {
                return MetaOAuthAuthorization.this.consentTemplateName;
            }
            return this.service.getDefaultConsentTemplateName();
        }

        public boolean hasAvailableRole() {
            if (MetaOAuthAuthorization.this.availableRoles == null) {
                return false;
            }
            AuthContext ac = AuthContext.getCurrentContext();
            for (String r : MetaOAuthAuthorization.this.availableRoles) {
                if ("*".equals(r)) {
                    return true;
                }
                if (!ac.userInRole(r)) continue;
                return true;
            }
            return false;
        }

        public OAuthTokens exchangeCodeToToken(String codeStr, String redirectUri, String codeVerifier, MetaOAuthClient.OAuthClientRuntime client) {
            if (!MetaOAuthAuthorization.this.getId().equals(client.getMetaData().getAuthorizationServerId())) {
                throw new OAuthRuntimeException("client's authServer is unmatch");
            }
            AuthorizationCode code = this.service.getAuthorizationCodeStore().getAndRemoveAuthorizationCode(codeStr);
            if (code == null || !code.getRequest().getClientId().equals(client.getMetaData().getName()) || !code.getRequest().getRedirectUri().equals(redirectUri) || code.getExpires() < System.currentTimeMillis()) {
                throw new OAuthApplicationException("invalid_grant", "invalid code/redirect_uri/client_id/code_verifier.");
            }
            if (code.getRequest().getCodeChallenge() != null ? !code.getRequest().getCodeChallenge().equals(OAuthUtil.calcCodeChallenge(code.getRequest().getCodeChallengeMethod(), codeVerifier)) : codeVerifier != null) {
                throw new OAuthApplicationException("invalid_grant", "invalid code/redirect_uri/client_id/code_verifier.");
            }
            AccessToken accessToken = this.service.getAccessTokenStore().createAccessToken(client, code.getRequest().getUser().getOid(), code.getRequest().getScopes());
            IdToken idToken = null;
            if (code.getRequest().getScopes().contains("openid")) {
                idToken = new IdToken(code, accessToken, this, client, this.service);
            }
            return new OAuthTokens(accessToken, idToken);
        }

        public AccessToken refreshToken(String refreshTokenStr, MetaOAuthClient.OAuthClientRuntime client) {
            if (!MetaOAuthAuthorization.this.getId().equals(client.getMetaData().getAuthorizationServerId())) {
                throw new OAuthRuntimeException("client's authServer is unmatch");
            }
            if (client.getMetaData().getGrantTypes() == null || !client.getMetaData().getGrantTypes().contains((Object)GrantType.REFRESH_TOKEN)) {
                throw new OAuthApplicationException("unauthorized_client", "grant_type not allowed.");
            }
            MetaClientPolicy.ClientPolicyRuntime clientPolicy = this.clientPolicyRuntimeMap.get((Object)client.getMetaData().getClientType());
            if (!clientPolicy.getMetaData().isSupportRefreshToken()) {
                throw new OAuthApplicationException("unauthorized_client", "grant_type not allowed.");
            }
            RefreshToken refreshToken = this.service.getAccessTokenStore().getRefreshToken(refreshTokenStr);
            if (refreshToken == null) {
                throw new OAuthApplicationException("invalid_grant", "invalid refresh_token.");
            }
            if (refreshToken.getExpiresIn() <= 0L) {
                throw new OAuthApplicationException("invalid_grant", "invalid refresh_token.");
            }
            if (!refreshToken.getClientId().equals(client.getMetaData().getName())) {
                throw new OAuthApplicationException("invalid_grant", "invalid refresh_token.");
            }
            AccessToken accessToken = this.service.getAccessTokenStore().createAccessToken(client, refreshToken);
            if (accessToken == null) {
                throw new OAuthApplicationException("invalid_grant", "invalid refresh_token.");
            }
            return accessToken;
        }

        public void revoke(String tokenStr, String tokenTypeHint, MetaOAuthClient.OAuthClientRuntime client) {
            if (!MetaOAuthAuthorization.this.getId().equals(client.getMetaData().getAuthorizationServerId())) {
                throw new OAuthRuntimeException("client's authServer is unmatch");
            }
            this.service.getAccessTokenStore().revokeToken(client, tokenStr, tokenTypeHint);
        }

        public String issuerId(RequestContext request) {
            if (MetaOAuthAuthorization.this.issuerUri != null) {
                return MetaOAuthAuthorization.this.issuerUri;
            }
            HttpServletRequest httpReq = (HttpServletRequest)request.getAttribute("servletRequest");
            StringBuilder sb = new StringBuilder();
            if (httpReq.isSecure()) {
                sb.append("https://");
            } else {
                sb.append("http://");
            }
            sb.append(httpReq.getServerName());
            int port = httpReq.getServerPort();
            if (httpReq.isSecure() && port != 443 || !httpReq.isSecure() && port != 80) {
                sb.append(':').append(port);
            }
            sb.append(TemplateUtil.getTenantContextPath());
            sb.append("/oauth");
            if (!"DEFAULT".equals(MetaOAuthAuthorization.this.getName())) {
                sb.append("/");
                sb.append(MetaOAuthAuthorization.this.getName());
            }
            return sb.toString();
        }

        public Map<String, Object> userInfo(AccessToken accessToken, MetaOAuthClient.OAuthClientRuntime client) {
            if (!MetaOAuthAuthorization.this.getId().equals(client.getMetaData().getAuthorizationServerId())) {
                throw new OAuthRuntimeException("client's authServer is unmatch");
            }
            HashMap<String, Object> userInfoClaims = new HashMap<String, Object>();
            for (String s : accessToken.getGrantedScopes()) {
                MetaOIDCClaimScope.OIDCClaimScopeRuntime csr = this.getOIDCClaimScope(s);
                if (csr == null) continue;
                csr.map(accessToken.getUser(), userInfoClaims);
            }
            String sub = this.getSubjectIdentifierType().subjectId(accessToken.getUser(), client);
            userInfoClaims.put("sub", sub);
            return userInfoClaims;
        }
    }
}

