/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.action;

import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.action.ActionParameterBinding;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.command.SessionBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.web.actionmapping.permission.ActionParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActionPermissionEntry {
    private static final Logger logger = LoggerFactory.getLogger(ActionPermissionEntry.class);
    private static final String SCRIPT_PREFIX = "ActionPermissionEntry_parameterCond";
    private final String role;
    private final Script parameterCondition;
    private final boolean isScriptError;

    ActionPermissionEntry(String role, String oid, String parameterConditionExp) {
        this.role = role;
        boolean localIsScriptError = false;
        Script localParameterCondition = null;
        if (parameterConditionExp != null) {
            ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
            try {
                localParameterCondition = se.createScript(parameterConditionExp, "ActionPermissionEntry_parameterCond_" + oid);
            }
            catch (RuntimeException e) {
                logger.error("parameter condition expression is invalid, so set permission to Not Allowed: " + parameterConditionExp, (Throwable)e);
                localIsScriptError = true;
            }
        }
        this.isScriptError = localIsScriptError;
        this.parameterCondition = localParameterCondition;
    }

    public boolean hasParam() {
        return this.parameterCondition != null;
    }

    public String getRole() {
        return this.role;
    }

    public boolean isPermit(AuthContextHolder authContextHolder, String actionName, ActionParameter param, TenantAuthorizeContext tenantContext) {
        Boolean ret;
        if (this.isScriptError) {
            return false;
        }
        if (this.parameterCondition == null) {
            return true;
        }
        ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
        ScriptContext sc = se.newScriptContext();
        sc.setAttribute("user", (Object)authContextHolder.newUserBinding(tenantContext));
        sc.setAttribute("session", (Object)SessionBinding.newSessionBinding());
        sc.setAttribute("action", (Object)actionName);
        sc.setAttribute("parameter", (Object)new ActionParameterBinding(param));
        sc.setAttribute("request", (Object)RequestContextBinding.newRequestContextBinding());
        try {
            ret = (Boolean)this.parameterCondition.eval(sc);
        }
        catch (RuntimeException e) {
            logger.error("can not eval condition expression. so return not Allowed:" + e.getMessage(), (Throwable)e);
            return false;
        }
        return ret != null && ret != false;
    }
}

