/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc.jwks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.iplass.mtp.impl.auth.authenticate.oidc.jwks.Jwks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteJwks
extends Jwks {
    private static Logger logger = LoggerFactory.getLogger(RemoteJwks.class);
    private String jwksEndpoint;
    private volatile JwksHolder jwks;

    public RemoteJwks(String jwksEndpoint, OpenIdConnectService service) {
        super(service);
        this.jwksEndpoint = jwksEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> get(String kid) {
        Map<String, Object> ret = this.getJwk(kid);
        if (ret == null) {
            RemoteJwks remoteJwks = this;
            synchronized (remoteJwks) {
                ret = this.getJwk(kid);
                if (ret == null) {
                    this.refreshJwks();
                    ret = this.getJwk(kid);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshJwks() {
        HttpClient client = this.service.getHttpClient();
        try {
            String content = null;
            HttpGet get = new HttpGet(this.jwksEndpoint);
            HttpResponse res = client.execute((HttpUriRequest)get);
            try {
                if (res.getStatusLine().getStatusCode() != 200) {
                    throw new IllegalStateException("http response error:" + res.getStatusLine().toString());
                }
                HttpEntity entity = res.getEntity();
                content = EntityUtils.toString((HttpEntity)entity);
            }
            finally {
                get.releaseConnection();
            }
            JwksHolder newJwks = new JwksHolder();
            newJwks.jwks = this.toJwksMap(content);
            if (this.service.getJwksCacheLifetimeMinutes() >= 0) {
                newJwks.ttl = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(this.service.getJwksCacheLifetimeMinutes());
            }
            this.jwks = newJwks;
        }
        catch (IOException | RuntimeException e) {
            logger.error("can not get jwks from endpoint:" + this.jwksEndpoint + " may be retry after a while...", (Throwable)e);
        }
    }

    private Map<String, Map<String, Object>> getJwksMap() {
        JwksHolder jwksref = this.jwks;
        if (jwksref == null || jwksref.ttl != -1L && jwksref.ttl < System.currentTimeMillis()) {
            return null;
        }
        return jwksref.jwks;
    }

    private Map<String, Object> getJwk(String kid) {
        Map<String, Map<String, Object>> jwksMap = this.getJwksMap();
        if (jwksMap == null) {
            return null;
        }
        return jwksMap.get(kid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> kidList() {
        ArrayList<String> ret = new ArrayList<String>();
        Map<String, Map<String, Object>> map = this.getJwksMap();
        if (map == null) {
            RemoteJwks remoteJwks = this;
            synchronized (remoteJwks) {
                map = this.getJwksMap();
                if (map == null) {
                    this.refreshJwks();
                    map = this.getJwksMap();
                }
            }
        }
        map.forEach((k, v) -> ret.add((String)v.get("kid")));
        return ret;
    }

    class JwksHolder {
        Map<String, Map<String, Object>> jwks;
        long ttl = -1L;

        JwksHolder() {
        }
    }
}

