/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc.command;

import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.impl.auth.authenticate.oidc.MetaOpenIdConnect;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCRuntimeException;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCState;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.web.WebUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="oidc/auth", clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, publicAction=true, paramMapping={@ParamMapping(name="defName", mapFrom="${paths}")}, result={@Result(status="SUCCESS", type=Result.Type.REDIRECT, allowExternalLocation=true, value="redirectPath")})
@CommandClass(name="mtp/oidc/AuthCommand", displayName="OpenID Connect Login processing")
public class AuthCommand
implements Command {
    public static final String PARAM_DEFINITION_NAME = "defName";
    public static final String REQUEST_ERROR_TEMPLATE = "org.iplass.mtp.oidc.errorTemplate";
    public static final String ACTION_NAME = "oidc/auth";
    public static final String STAT_SUCCESS = "SUCCESS";
    public static final String SESSION_OIDC_STATE = "org.iplass.mtp.oidc.state";
    private static Logger logger = LoggerFactory.getLogger(AuthCommand.class);
    private OpenIdConnectService service = (OpenIdConnectService)ServiceRegistry.getRegistry().getService(OpenIdConnectService.class);

    public String execute(RequestContext request) {
        String defName = StringUtil.stripToNull((String)request.getParam(PARAM_DEFINITION_NAME));
        MetaOpenIdConnect.OpenIdConnectRuntime oidp = this.service.getOrDefault(defName);
        if (oidp == null) {
            throw new OIDCRuntimeException("no OpenIdProvider Definition:" + defName);
        }
        String backUrlAfterAuth = oidp.backUrlAfterAuth(request);
        if (backUrlAfterAuth == null) {
            backUrlAfterAuth = (String)request.getAttribute("redirectPath");
        }
        if (backUrlAfterAuth == null) {
            Tenant tenant = ExecuteContext.getCurrentContext().getCurrentTenant();
            String menuUrl = WebUtil.getTenantWebInfo(tenant).getHomeUrl();
            backUrlAfterAuth = menuUrl != null && menuUrl.length() != 0 ? TemplateUtil.getTenantContextPath() + menuUrl : TemplateUtil.getTenantContextPath() + "/";
        }
        String errorTemplate = (String)request.getAttribute(REQUEST_ERROR_TEMPLATE);
        OIDCState state = oidp.newOIDCState(backUrlAfterAuth, oidp.createRedirectUri(request, "oidc/authcb"), errorTemplate);
        request.getSession().setAttribute(SESSION_OIDC_STATE, (Object)state);
        String redirect = oidp.authorizeUrl(state);
        if (logger.isDebugEnabled()) {
            logger.debug("redirect to OP:" + redirect);
        }
        request.setAttribute("redirectPath", (Object)redirect);
        return STAT_SUCCESS;
    }
}

