/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc.command;

import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.impl.auth.authenticate.oidc.MetaOpenIdConnect;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCCredential;
import org.iplass.mtp.impl.auth.authenticate.oidc.command.AbstractCallbackCommand;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;

@ActionMapping(name="oidc/authcb", clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, publicAction=true, privileged=true, paramMapping={@ParamMapping(name="defName", mapFrom="${paths}")}, result={@Result(status="SUCCESS", type=Result.Type.REDIRECT, value="redirectPath"), @Result(exception=ApplicationException.class, type=Result.Type.DYNAMIC, value="org.iplass.mtp.oidc.errorTemplate")})
@CommandClass(name="mtp/oidc/AuthCallbackCommand", displayName="OpenID Connect Auth Callback processing")
public class AuthCallbackCommand
extends AbstractCallbackCommand {
    public static final String ACTION_NAME = "oidc/authcb";
    public static final String PARAM_DEFINITION_NAME = "defName";
    public static final String STAT_SUCCESS = "SUCCESS";
    private AuthManager auth = (AuthManager)ManagerLocator.getInstance().getManager(AuthManager.class);

    public AuthCallbackCommand() {
        super("org.iplass.mtp.oidc.state");
    }

    @Override
    public String execute(RequestContext request) {
        try {
            return super.execute(request);
        }
        catch (LoginFailedException e) {
            throw e;
        }
        catch (ApplicationException e) {
            throw new LoginFailedException(WebResourceBundleUtil.resourceString("impl.auth.authenticate.oidc.command.AuthCallbackCommand.error", new Object[0]) + " " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected void executeImpl(MetaOpenIdConnect.OpenIdConnectRuntime oidp, RequestContext request, OIDCCredential cre) {
        this.auth.login((Credential)cre);
    }

    @Override
    protected String createRedirectUri(MetaOpenIdConnect.OpenIdConnectRuntime oidp, RequestContext request) {
        return oidp.createRedirectUri(request, ACTION_NAME);
    }
}

