/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc.command;

import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.oidc.MetaOpenIdConnect;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCCredential;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCRuntimeException;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCValidateResult;
import org.iplass.mtp.impl.auth.authenticate.oidc.command.AbstractCallbackCommand;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.spi.ServiceRegistry;

@ActionMapping(name="oidc/connectcb", clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, paramMapping={@ParamMapping(name="defName", mapFrom="${paths}")}, result={@Result(status="SUCCESS", type=Result.Type.REDIRECT, value="redirectPath"), @Result(exception=ApplicationException.class, type=Result.Type.DYNAMIC, value="org.iplass.mtp.oidc.errorTemplate")})
@CommandClass(name="mtp/oidc/AccountConnectCallbackCommand", displayName="OpenID Connect Account Connect Callback processing")
public class AccountConnectCallbackCommand
extends AbstractCallbackCommand {
    public static final String ACTION_NAME = "oidc/connectcb";
    public static final String PARAM_DEFINITION_NAME = "defName";
    public static final String STAT_SUCCESS = "SUCCESS";
    private AuthenticationPolicyService policyService = (AuthenticationPolicyService)ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);

    public AccountConnectCallbackCommand() {
        super("org.iplass.mtp.oidc.connect.state");
    }

    @Override
    protected void executeImpl(MetaOpenIdConnect.OpenIdConnectRuntime oidp, RequestContext request, OIDCCredential cre) {
        OIDCValidateResult vr = oidp.validate(cre);
        if (!vr.isValid()) {
            OIDCRuntimeException ore = vr.getRootCause() == null ? new OIDCRuntimeException(vr.getError() + ":" + vr.getErrorDescription()) : new OIDCRuntimeException(vr.getError() + ":" + vr.getErrorDescription(), vr.getRootCause());
            throw new ApplicationException(WebResourceBundleUtil.resourceString("impl.auth.authenticate.oidc.command.AbstractCallbackCommand.error", new Object[]{"Invalid response from OpenID Provider.", "invalid_response"}), (Throwable)((Object)ore));
        }
        User user = AuthContext.getCurrentContext().getUser();
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime userPolicy = this.policyService.getOrDefault(user.getAccountPolicy());
        if (!oidp.isAllowedOnPolicy(userPolicy)) {
            throw new OIDCRuntimeException("policy not allow OpenIdConnectDefinition:" + oidp.getMetaData().getName());
        }
        oidp.connect(user.getOid(), vr);
    }

    @Override
    protected String createRedirectUri(MetaOpenIdConnect.OpenIdConnectRuntime oidp, RequestContext request) {
        return oidp.createRedirectUri(request, ACTION_NAME);
    }
}

