/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.EntityEventListener;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCAccountHandle;

public class OpenIdProviderAccountEntityEventListener
implements EntityEventListener {
    public static final String DEFINITION_NAME = "mtp.auth.oidc.OpenIdProviderAccount";
    public static final String UNIQUE_KEY = "uniqueKey";
    public static final String OIDC_DEFINITION_NAME = "openIdConnectDefinitionName";
    public static final String SUBJECT_ID = "subjectId";
    public static final String SUBJECT_NAME = "subjectName";
    public static final String USER = "user";
    public static final String USER_OID = "userOid";

    public void beforeValidate(Entity entity, EntityEventContext context) {
        UpdateOption option = (UpdateOption)context.getAttribute("updateOption");
        if (option == null) {
            entity.setValue(UNIQUE_KEY, (Object)OIDCAccountHandle.createSubjectUniqueKey((String)entity.getValue(SUBJECT_ID), (String)entity.getValue(OIDC_DEFINITION_NAME)));
            entity.setValue(USER_OID, (Object)((Entity)entity.getValue(USER)).getOid());
        }
    }

    public boolean beforeUpdate(Entity entity, EntityEventContext context) {
        UpdateOption option = (UpdateOption)context.getAttribute("updateOption");
        Entity before = (Entity)context.getAttribute("beforeUpdateEntity");
        if (option.getUpdateProperties().contains(OIDC_DEFINITION_NAME) || option.getUpdateProperties().contains(SUBJECT_ID)) {
            String sub = (String)before.getValue(SUBJECT_ID);
            if (option.getUpdateProperties().contains(SUBJECT_ID)) {
                sub = (String)entity.getValue(SUBJECT_ID);
            }
            String providerName = (String)before.getValue(OIDC_DEFINITION_NAME);
            if (option.getUpdateProperties().contains(OIDC_DEFINITION_NAME)) {
                providerName = (String)entity.getValue(OIDC_DEFINITION_NAME);
            }
            entity.setValue(UNIQUE_KEY, (Object)OIDCAccountHandle.createSubjectUniqueKey(sub, providerName));
            if (!option.getUpdateProperties().contains(UNIQUE_KEY)) {
                option.getUpdateProperties().add(UNIQUE_KEY);
            }
        }
        if (option.getUpdateProperties().contains(USER)) {
            entity.setValue(USER_OID, (Object)((Entity)entity.getValue(USER)).getOid());
            if (!option.getUpdateProperties().contains(USER_OID)) {
                option.getUpdateProperties().add(USER_OID);
            }
        }
        return true;
    }
}

