/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.http.client.HttpClient;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.oidc.definition.OpenIdConnectDefinition;
import org.iplass.mtp.auth.oidc.definition.OpenIdConnectDefinitionManager;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.auth.authenticate.oidc.ClientSecretHandler;
import org.iplass.mtp.impl.auth.authenticate.oidc.MetaOpenIdConnect;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.http.HttpClientConfig;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;

public class OpenIdConnectService
extends AbstractTypedMetaDataService<MetaOpenIdConnect, MetaOpenIdConnect.OpenIdConnectRuntime>
implements Service {
    public static final String OIDC_PATH = "/oidc/";
    public static final String DEFAULT_NAME = "DEFAULT";
    private HttpClientConfig httpClientConfig;
    private ObjectMapper objectMapper;
    private ClientSecretHandler clientSecretHandler;
    private int allowedClockSkewMinutes;
    private int jwksCacheLifetimeMinutes = 360;
    private String clientSecretType = "OIDCCS";

    public String getClientSecretType() {
        return this.clientSecretType;
    }

    public int getAllowedClockSkewMinutes() {
        return this.allowedClockSkewMinutes;
    }

    public int getJwksCacheLifetimeMinutes() {
        return this.jwksCacheLifetimeMinutes;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public HttpClient getHttpClient() {
        return this.httpClientConfig.getInstance();
    }

    public Class<MetaOpenIdConnect> getMetaDataType() {
        return MetaOpenIdConnect.class;
    }

    public Class<MetaOpenIdConnect.OpenIdConnectRuntime> getRuntimeType() {
        return MetaOpenIdConnect.OpenIdConnectRuntime.class;
    }

    public void init(Config config) {
        this.allowedClockSkewMinutes = (Integer)config.getValue("allowedClockSkewMinutes", Integer.TYPE, (Object)0);
        this.jwksCacheLifetimeMinutes = (Integer)config.getValue("jwksCacheLifetimeMinutes", Integer.TYPE, (Object)360);
        this.clientSecretType = (String)config.getValue("clientSecretType", String.class, (Object)"OIDCCS");
        this.httpClientConfig = (HttpClientConfig)config.getValue("httpClientConfig", HttpClientConfig.class);
        if (this.httpClientConfig == null) {
            this.httpClientConfig = new HttpClientConfig();
            this.httpClientConfig.inited((Service)this, config);
        }
        this.objectMapper = new ObjectMapper();
        this.clientSecretHandler = (ClientSecretHandler)((AuthTokenService)ServiceRegistry.getRegistry().getService(AuthTokenService.class)).getHandler(this.clientSecretType);
    }

    public void destroy() {
    }

    public MetaOpenIdConnect.OpenIdConnectRuntime getOrDefault(String defName) {
        if (defName == null) {
            defName = DEFAULT_NAME;
        }
        return (MetaOpenIdConnect.OpenIdConnectRuntime)MetaDataContext.getContext().getMetaDataHandler(MetaOpenIdConnect.OpenIdConnectRuntime.class, OIDC_PATH + defName);
    }

    String getClientSecret(String metaDataId) {
        return this.clientSecretHandler.getClientSecret(metaDataId);
    }

    public void saveClientSecret(String metaDataId, String clientSecret) {
        this.clientSecretHandler.saveClientSecret(metaDataId, clientSecret);
        MetaDataContext.getContext().reloadById(metaDataId);
    }

    public void removeMetaData(String definitionName) {
        MetaOpenIdConnect.OpenIdConnectRuntime r = (MetaOpenIdConnect.OpenIdConnectRuntime)this.getRuntimeByName(definitionName);
        if (r != null) {
            this.clientSecretHandler.deleteClientSecret(r.getMetaData().getId());
        }
        super.removeMetaData(definitionName);
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<OpenIdConnectDefinition, MetaOpenIdConnect> {
        public TypeMap() {
            super(OpenIdConnectService.OIDC_PATH, MetaOpenIdConnect.class, OpenIdConnectDefinition.class);
        }

        public TypedDefinitionManager<OpenIdConnectDefinition> typedDefinitionManager() {
            return (TypedDefinitionManager)ManagerLocator.getInstance().getManager(OpenIdConnectDefinitionManager.class);
        }
    }
}

