/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.iplass.mtp.auth.oidc.definition.ClientAuthenticationType;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCRuntimeException;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OPEndpoint {
    private static Logger logger = LoggerFactory.getLogger(OPEndpoint.class);
    private String tokenEndpointUrl;
    private String userInfoEndpointUrl;
    private OpenIdConnectService opService;

    public OPEndpoint(String tokenEndpointUrl, String userInfoEndpointUrl, OpenIdConnectService opService) {
        this.tokenEndpointUrl = tokenEndpointUrl;
        this.userInfoEndpointUrl = userInfoEndpointUrl;
        this.opService = opService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> token(ClientAuthenticationType clientAuthenticationType, String clientId, String clientSecret, String code, String redirectUri, String codeVerifier) {
        try {
            String content = null;
            HttpClient client = this.opService.getHttpClient();
            HttpPost post = new HttpPost(this.tokenEndpointUrl);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            if (clientAuthenticationType == ClientAuthenticationType.CLIENT_SECRET_BASIC) {
                post.setHeader("Authorization", "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes("UTF-8")));
            } else {
                nvps.add(new BasicNameValuePair("client_id", clientId));
                nvps.add(new BasicNameValuePair("client_secret", clientSecret));
            }
            nvps.add(new BasicNameValuePair("code", code));
            nvps.add(new BasicNameValuePair("redirect_uri", redirectUri));
            nvps.add(new BasicNameValuePair("grant_type", "authorization_code"));
            if (codeVerifier != null) {
                nvps.add(new BasicNameValuePair("code_verifier", codeVerifier));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            HttpResponse res = client.execute((HttpUriRequest)post);
            try {
                HttpEntity entity = res.getEntity();
                content = EntityUtils.toString((HttpEntity)entity);
            }
            finally {
                post.releaseConnection();
            }
            return (Map)this.opService.getObjectMapper().readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException | ParseException e) {
            throw new OIDCRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> userInfo(String tokenType, String accessToken) {
        try {
            HttpGet get = new HttpGet(this.userInfoEndpointUrl);
            get.setHeader("Authorization", tokenType + " " + accessToken);
            HttpResponse res = this.opService.getHttpClient().execute((HttpUriRequest)get);
            try {
                Map ret;
                HttpEntity entity = res.getEntity();
                StatusLine sl = res.getStatusLine();
                String content = EntityUtils.toString((HttpEntity)entity);
                if (sl.getStatusCode() != 200) {
                    logger.warn("can't get user's profile caluse http status=" + sl.getStatusCode() + " " + sl.getReasonPhrase() + " content=" + content);
                    Map<String, Object> map = null;
                    return map;
                }
                Map map = ret = (Map)this.opService.getObjectMapper().readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
                return map;
            }
            finally {
                get.releaseConnection();
            }
        }
        catch (IOException | ParseException e) {
            throw new OIDCRuntimeException(e);
        }
    }
}

