/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.LoginFailedException;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.DefaultUserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.oidc.MetaOpenIdConnect;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCCredential;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCRuntimeException;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCUserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCValidateResult;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCAuthenticationProvider
extends AuthenticationProviderBase {
    private static final Logger authLog = LoggerFactory.getLogger((String)"mtp.auth.oidc");
    private OpenIdConnectService oidcService;
    private AuthenticationPolicyService policyService;

    public void inited(AuthService service, Config config) {
        if (this.getUserEntityResolver() == null) {
            OIDCUserEntityResolver er = new OIDCUserEntityResolver();
            er.setEagerLoadReferenceProperty(DefaultUserEntityResolver.DEFAULT_EAGER_LOAD_REFERENCE_PROPERTY);
            this.setUserEntityResolver(er);
        }
        super.inited(service, config);
        this.oidcService = (OpenIdConnectService)ServiceRegistry.getRegistry().getService(OpenIdConnectService.class);
        this.policyService = (AuthenticationPolicyService)ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
    }

    public AccountManagementModule getAccountManagementModule() {
        return NO_UPDATABLE_AMM;
    }

    public Class<? extends Credential> getCredentialType() {
        return OIDCCredential.class;
    }

    protected Class<? extends AccountHandle> getAccountHandleClassForTrust() {
        return OIDCAccountHandle.class;
    }

    public AccountHandle login(Credential credential) {
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime userPolicy;
        if (!(credential instanceof OIDCCredential)) {
            return null;
        }
        OIDCCredential cre = (OIDCCredential)credential;
        MetaOpenIdConnect.OpenIdConnectRuntime oidcRuntime = this.oidcService.getOrDefault(cre.getOpenIdConnectDefinitionName());
        OIDCValidateResult vr = oidcRuntime.validate(cre);
        if (!vr.isValid()) {
            if (authLog.isDebugEnabled()) {
                if (vr.getRootCause() == null) {
                    authLog.debug("OIDC failed:error=" + vr.getError() + ", errorDescription=" + vr.getErrorDescription());
                } else {
                    authLog.debug("OIDC failed:error=" + vr.getError() + ", errorDescription=" + vr.getErrorDescription() + "exception=" + vr.getRootCause(), (Throwable)vr.getRootCause());
                }
            }
            OIDCRuntimeException ore = vr.getRootCause() == null ? new OIDCRuntimeException(vr.getError() + ":" + vr.getErrorDescription()) : new OIDCRuntimeException(vr.getError() + ":" + vr.getErrorDescription(), vr.getRootCause());
            throw new LoginFailedException(WebResourceBundleUtil.resourceString("impl.auth.authenticate.oidc.OIDCAuthenticationProvider.error", new Object[]{"Invalid response from OpenID Provider.", "invalid_response"}), (Throwable)((Object)ore));
        }
        OIDCAccountHandle ah = new OIDCAccountHandle(vr.getSubjectId(), vr.getSubjectName(), oidcRuntime.getMetaData().getName(), vr.getClaims(), vr.getAccessToken(), vr.getExpiresIn(), vr.getRefreshToken(), vr.getScopes());
        User user = this.getUserEntityResolver().searchUser((AccountHandle)ah);
        if (user == null) {
            if (oidcRuntime.getAutoUserProvisioningHandler() != null) {
                user = (User)AuthContext.doPrivileged(() -> {
                    String userOid = oidcRuntime.getAutoUserProvisioningHandler().createUser(vr.getSubjectId(), vr.getSubjectName(), ah.getAttributeMap());
                    if (userOid != null) {
                        oidcRuntime.connect(userOid, vr);
                        return this.getUserEntityResolver().searchUser((AccountHandle)ah);
                    }
                    return null;
                });
            }
            if (user == null) {
                throw new LoginFailedException(WebResourceBundleUtil.resourceString("impl.auth.authenticate.oidc.OIDCAuthenticationProvider.error", new Object[]{"", "account_not_available"}));
            }
        } else if (oidcRuntime.getAutoUserProvisioningHandler() != null) {
            User refUser = user;
            user = (User)AuthContext.doPrivileged(() -> {
                oidcRuntime.getAutoUserProvisioningHandler().updateUser(refUser, vr.getSubjectId(), vr.getSubjectName(), ah.getAttributeMap());
                return this.getUserEntityResolver().searchUser((AccountHandle)ah);
            });
        }
        if (!oidcRuntime.isAllowedOnPolicy(userPolicy = this.policyService.getOrDefault(user.getAccountPolicy()))) {
            throw new LoginFailedException(WebResourceBundleUtil.resourceString("impl.auth.authenticate.oidc.OIDCAuthenticationProvider.error", new Object[]{"", "account_policy_error"}), (Throwable)((Object)new OIDCRuntimeException("policy not allow OpenIdConnectDefinition:" + oidcRuntime.getMetaData().getName())));
        }
        ah.setId(user.getAccountId());
        return ah;
    }

    public void logout(AccountHandle user) {
    }
}

