/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCCredential;

public class OIDCAccountHandle
implements AccountHandle {
    private static final long serialVersionUID = 7261716807599677842L;
    public static final String OIDC_DEFINITION_NAME = "openIdConnectDefinitionName";
    public static final String SUBJECT_ID_WITH_DEFINITION_NAME = "subjectIdWithOpenIdConnectDefinitionName";
    public static final String EMAIL_VERIFIED = "email_verified";
    public static final String EMAIL = "email";
    public static final String GIVEN_NAME = "given_name";
    public static final String FAMILY_NAME = "family_name";
    public static final String UNIQUE_KEY_SEPARATOR = "@";
    private String id;
    private String uniqueKey;
    private Map<String, Object> attributeMap;
    private int authenticationProviderIndex;
    private String subjectId;
    private String subjectName;
    private String accessToken;
    private Long accessTokenExpiresIn;
    private String refreshToken;
    private Set<String> scopes;

    public static String createSubjectUniqueKey(String subjectId, String openIdConnectDefinitionName) {
        try {
            subjectId = URLEncoder.encode(subjectId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException((Throwable)e);
        }
        String uniqueKey = "DEFAULT".equals(openIdConnectDefinitionName) ? subjectId : subjectId + UNIQUE_KEY_SEPARATOR + openIdConnectDefinitionName.replace('/', '.');
        return uniqueKey;
    }

    public static String[] subjectAndDefinitionNameFromUniqueKey(String uniqueKey) {
        String sub = null;
        String defName = null;
        int i = uniqueKey.lastIndexOf(UNIQUE_KEY_SEPARATOR);
        if (i < 0) {
            sub = uniqueKey;
            defName = "DEFAULT";
        } else {
            sub = uniqueKey.substring(0, i);
            defName = uniqueKey.substring(i + 1);
        }
        try {
            sub = URLDecoder.decode(sub, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException((Throwable)e);
        }
        defName = defName.replace('.', '/');
        return new String[]{sub, defName};
    }

    public OIDCAccountHandle(String subjectId, String subjectName, String openIdConnectDefinitionName, Map<String, Object> attributeMap, String accessToken, Long accessTokenExpiresIn, String refreshToken, Set<String> scopes) {
        this.subjectId = subjectId;
        this.uniqueKey = OIDCAccountHandle.createSubjectUniqueKey(subjectId, openIdConnectDefinitionName);
        this.subjectName = subjectName;
        this.attributeMap = attributeMap != null ? attributeMap : new HashMap<String, Object>();
        this.attributeMap.put(OIDC_DEFINITION_NAME, openIdConnectDefinitionName);
        this.attributeMap.put(SUBJECT_ID_WITH_DEFINITION_NAME, this.uniqueKey);
        this.accessToken = accessToken;
        this.accessTokenExpiresIn = accessTokenExpiresIn;
        this.refreshToken = refreshToken;
        this.scopes = scopes;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Long getAccessTokenExpiresIn() {
        return this.accessTokenExpiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public String getOpenIdConnectDefinitionName() {
        return (String)this.attributeMap.get(OIDC_DEFINITION_NAME);
    }

    public boolean isAccountLocked() {
        return false;
    }

    public boolean isExpired() {
        return false;
    }

    public boolean isInitialLogin() {
        return false;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public Credential getCredential() {
        return new OIDCCredential(this.id);
    }

    public void setAuthenticationProviderIndex(int authenticationProviderIndex) {
        this.authenticationProviderIndex = authenticationProviderIndex;
    }

    public int getAuthenticationProviderIndex() {
        return this.authenticationProviderIndex;
    }

    public String getUnmodifiableUniqueKey() {
        return this.uniqueKey;
    }
}

