/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.oidc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.oidc.AutoUserProvisioningHandler;
import org.iplass.mtp.auth.oidc.definition.ClientAuthenticationType;
import org.iplass.mtp.auth.oidc.definition.OpenIdConnectDefinition;
import org.iplass.mtp.auth.oidc.definition.ResponseMode;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCCredential;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCState;
import org.iplass.mtp.impl.auth.authenticate.oidc.OIDCValidateResult;
import org.iplass.mtp.impl.auth.authenticate.oidc.OPEndpoint;
import org.iplass.mtp.impl.auth.authenticate.oidc.OpenIdConnectService;
import org.iplass.mtp.impl.auth.authenticate.oidc.jwks.Jwks;
import org.iplass.mtp.impl.auth.authenticate.oidc.jwks.LocalJwks;
import org.iplass.mtp.impl.auth.authenticate.oidc.jwks.RemoteJwks;
import org.iplass.mtp.impl.auth.oauth.jwt.InvalidJwtException;
import org.iplass.mtp.impl.auth.oauth.jwt.Jwt;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtProcessor;
import org.iplass.mtp.impl.auth.oauth.util.OAuthUtil;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptRuntimeException;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.util.random.SecureRandomGenerator;
import org.iplass.mtp.impl.util.random.SecureRandomService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.utilityclass.definition.UtilityClassDefinitionManager;
import org.iplass.mtp.web.template.TemplateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaOpenIdConnect
extends BaseRootMetaData
implements DefinableMetaData<OpenIdConnectDefinition> {
    private static final long serialVersionUID = -4429152263057997180L;
    private static Logger logger = LoggerFactory.getLogger(MetaOpenIdConnect.class);
    private String issuer;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String userInfoEndpoint;
    private String jwksEndpoint;
    private String jwksContents;
    private String clientId;
    private List<String> scopes;
    private ClientAuthenticationType clientAuthenticationType;
    private boolean useNonce = true;
    private boolean enablePKCE = true;
    private boolean issParameterSupported = true;
    private boolean validateSign;
    private ResponseMode responseMode = ResponseMode.FORM_POST;
    private String subjectNameClaim = "preferred_username";
    private String autoUserProvisioningHandler;
    private boolean enableTransientUser;
    private String backUrlAfterAuth;
    private String backUrlAfterConnect;

    public String getBackUrlAfterAuth() {
        return this.backUrlAfterAuth;
    }

    public void setBackUrlAfterAuth(String backUrlAfterAuth) {
        this.backUrlAfterAuth = backUrlAfterAuth;
    }

    public String getBackUrlAfterConnect() {
        return this.backUrlAfterConnect;
    }

    public void setBackUrlAfterConnect(String backUrlAfterConnect) {
        this.backUrlAfterConnect = backUrlAfterConnect;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public String getJwksEndpoint() {
        return this.jwksEndpoint;
    }

    public void setJwksEndpoint(String jwksEndpoint) {
        this.jwksEndpoint = jwksEndpoint;
    }

    public String getJwksContents() {
        return this.jwksContents;
    }

    public void setJwksContents(String jwksContents) {
        this.jwksContents = jwksContents;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ClientAuthenticationType getClientAuthenticationType() {
        return this.clientAuthenticationType;
    }

    public void setClientAuthenticationType(ClientAuthenticationType clientAuthenticationType) {
        this.clientAuthenticationType = clientAuthenticationType;
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public void setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
    }

    public boolean isEnablePKCE() {
        return this.enablePKCE;
    }

    public void setEnablePKCE(boolean enablePKCE) {
        this.enablePKCE = enablePKCE;
    }

    public boolean isIssParameterSupported() {
        return this.issParameterSupported;
    }

    public void setIssParameterSupported(boolean issParameterSupported) {
        this.issParameterSupported = issParameterSupported;
    }

    public boolean isValidateSign() {
        return this.validateSign;
    }

    public void setValidateSign(boolean validateSign) {
        this.validateSign = validateSign;
    }

    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(ResponseMode responseMode) {
        this.responseMode = responseMode;
    }

    public String getSubjectNameClaim() {
        return this.subjectNameClaim;
    }

    public void setSubjectNameClaim(String subjectNameClaim) {
        this.subjectNameClaim = subjectNameClaim;
    }

    public String getAutoUserProvisioningHandler() {
        return this.autoUserProvisioningHandler;
    }

    public void setAutoUserProvisioningHandler(String autoUserProvisioningHandler) {
        this.autoUserProvisioningHandler = autoUserProvisioningHandler;
    }

    public boolean isEnableTransientUser() {
        return this.enableTransientUser;
    }

    public void setEnableTransientUser(boolean enableTransientUser) {
        this.enableTransientUser = enableTransientUser;
    }

    public MetaDataRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new OpenIdConnectRuntime();
    }

    public MetaOpenIdConnect copy() {
        return (MetaOpenIdConnect)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public void applyConfig(OpenIdConnectDefinition def) {
        this.name = def.getName();
        this.description = def.getDescription();
        this.displayName = def.getDisplayName();
        this.localizedDisplayNameList = I18nUtil.toMeta(def.getLocalizedDisplayNameList());
        this.issuer = def.getIssuer();
        this.authorizationEndpoint = def.getAuthorizationEndpoint();
        this.tokenEndpoint = def.getTokenEndpoint();
        this.userInfoEndpoint = def.getUserInfoEndpoint();
        this.jwksEndpoint = def.getJwksEndpoint();
        this.jwksContents = def.getJwksContents();
        this.clientId = def.getClientId();
        this.scopes = def.getScopes() == null ? null : new ArrayList<String>(def.getScopes());
        this.clientAuthenticationType = def.getClientAuthenticationType();
        this.useNonce = def.isUseNonce();
        this.enablePKCE = def.isEnablePKCE();
        this.issParameterSupported = def.isIssParameterSupported();
        this.validateSign = def.isValidateSign();
        this.responseMode = def.getResponseMode();
        this.subjectNameClaim = def.getSubjectNameClaim();
        this.autoUserProvisioningHandler = def.getAutoUserProvisioningHandler();
        this.enableTransientUser = def.isEnableTransientUser();
        this.backUrlAfterAuth = def.getBackUrlAfterAuth();
        this.backUrlAfterConnect = def.getBackUrlAfterConnect();
    }

    public OpenIdConnectDefinition currentConfig() {
        OpenIdConnectDefinition def = new OpenIdConnectDefinition();
        def.setName(this.name);
        def.setDescription(this.description);
        def.setDisplayName(this.displayName);
        def.setLocalizedDisplayNameList(I18nUtil.toDef((List)this.localizedDisplayNameList));
        def.setIssuer(this.issuer);
        def.setAuthorizationEndpoint(this.authorizationEndpoint);
        def.setTokenEndpoint(this.tokenEndpoint);
        def.setUserInfoEndpoint(this.userInfoEndpoint);
        def.setJwksEndpoint(this.jwksEndpoint);
        def.setJwksContents(this.jwksContents);
        def.setClientId(this.clientId);
        if (this.scopes != null) {
            def.setScopes(new ArrayList<String>(this.scopes));
        }
        def.setClientAuthenticationType(this.clientAuthenticationType);
        def.setUseNonce(this.useNonce);
        def.setEnablePKCE(this.enablePKCE);
        def.setIssParameterSupported(this.issParameterSupported);
        def.setValidateSign(this.validateSign);
        def.setResponseMode(this.responseMode);
        def.setSubjectNameClaim(this.subjectNameClaim);
        def.setAutoUserProvisioningHandler(this.autoUserProvisioningHandler);
        def.setEnableTransientUser(this.enableTransientUser);
        def.setBackUrlAfterAuth(this.backUrlAfterAuth);
        def.setBackUrlAfterConnect(this.backUrlAfterConnect);
        return def;
    }

    public class OpenIdConnectRuntime
    extends BaseMetaDataRuntime {
        private AutoUserProvisioningHandler aup;
        private String scopeParamValue;
        private HashSet<String> scopeParamSet;
        private OpenIdConnectService opService;
        private EntityManager em;
        private String clientSecret;
        private Jwks jwks;
        private OPEndpoint opEndpoint;
        private ScriptEngine scriptEngine = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
        private GroovyTemplate backUrlAfterAuthTmpl;
        private GroovyTemplate backUrlAfterConnectTmpl;

        private OpenIdConnectRuntime() {
            try {
                if (MetaOpenIdConnect.this.autoUserProvisioningHandler != null) {
                    try {
                        this.aup = (AutoUserProvisioningHandler)((UtilityClassDefinitionManager)ManagerLocator.getInstance().getManager(UtilityClassDefinitionManager.class)).createInstanceAs(AutoUserProvisioningHandler.class, MetaOpenIdConnect.this.autoUserProvisioningHandler);
                        this.aup.init(MetaOpenIdConnect.this.currentConfig());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException(e);
                    }
                }
                this.scopeParamSet = new HashSet();
                StringBuilder sb = new StringBuilder();
                sb.append("openid");
                this.scopeParamSet.add("openid");
                if (MetaOpenIdConnect.this.scopes != null && MetaOpenIdConnect.this.scopes.size() > 0) {
                    for (String sc : MetaOpenIdConnect.this.scopes) {
                        if ("openid".equals(sc)) continue;
                        sb.append(' ').append(sc);
                        this.scopeParamSet.add(sc);
                    }
                }
                this.scopeParamValue = sb.toString();
                this.opService = (OpenIdConnectService)ServiceRegistry.getRegistry().getService(OpenIdConnectService.class);
                this.em = (EntityManager)ManagerLocator.manager(EntityManager.class);
                this.clientSecret = this.opService.getClientSecret(MetaOpenIdConnect.this.getId());
                if (this.clientSecret == null) {
                    throw new IllegalStateException("Client Secret unspecified.");
                }
                if (MetaOpenIdConnect.this.jwksContents != null && !MetaOpenIdConnect.this.jwksContents.isEmpty()) {
                    this.jwks = new LocalJwks(MetaOpenIdConnect.this.jwksContents, this.opService);
                } else if (MetaOpenIdConnect.this.jwksEndpoint != null) {
                    this.jwks = new RemoteJwks(MetaOpenIdConnect.this.jwksEndpoint, this.opService);
                } else if (MetaOpenIdConnect.this.validateSign) {
                    throw new IllegalStateException("jwks endpoint or contents must specified");
                }
                this.opEndpoint = new OPEndpoint(MetaOpenIdConnect.this.tokenEndpoint, MetaOpenIdConnect.this.userInfoEndpoint, this.opService);
                if (MetaOpenIdConnect.this.issuer == null) {
                    throw new NullPointerException("issuer must specified");
                }
                if (MetaOpenIdConnect.this.authorizationEndpoint == null) {
                    throw new NullPointerException("authorizationEndpoint must specified");
                }
                if (MetaOpenIdConnect.this.tokenEndpoint == null) {
                    throw new NullPointerException("tokenEndpoint must specified");
                }
                if (MetaOpenIdConnect.this.clientId == null) {
                    throw new NullPointerException("clientId must specified");
                }
                if (MetaOpenIdConnect.this.clientAuthenticationType == null) {
                    throw new NullPointerException("clientAuthenticationType must specified");
                }
                if (MetaOpenIdConnect.this.subjectNameClaim == null) {
                    new NullPointerException("subjectNameClaim must specified");
                }
                if (MetaOpenIdConnect.this.backUrlAfterAuth != null) {
                    this.backUrlAfterAuthTmpl = GroovyTemplateCompiler.compile((String)MetaOpenIdConnect.this.backUrlAfterAuth, (String)("OpenIdConnect_backUrlAfterAuth_" + MetaOpenIdConnect.this.getName()), (GroovyScriptEngine)((GroovyScriptEngine)this.scriptEngine));
                }
                if (MetaOpenIdConnect.this.backUrlAfterConnect != null) {
                    this.backUrlAfterConnectTmpl = GroovyTemplateCompiler.compile((String)MetaOpenIdConnect.this.backUrlAfterConnect, (String)("OpenIdConnect_backUrlAfterConnect_" + MetaOpenIdConnect.this.getName()), (GroovyScriptEngine)((GroovyScriptEngine)this.scriptEngine));
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        void setOPEndpoint(OPEndpoint opEndpoint) {
            this.opEndpoint = opEndpoint;
        }

        OPEndpoint getOPEndpoint() {
            return this.opEndpoint;
        }

        public MetaOpenIdConnect getMetaData() {
            return MetaOpenIdConnect.this;
        }

        public AutoUserProvisioningHandler getAutoUserProvisioningHandler() {
            return this.aup;
        }

        public String backUrlAfterAuth(RequestContext req) {
            return this.doTmpl(this.backUrlAfterAuthTmpl, req);
        }

        private String doTmpl(GroovyTemplate tmpl, RequestContext req) {
            if (tmpl == null) {
                return null;
            }
            HashMap<String, RequestContext> binding = new HashMap<String, RequestContext>();
            binding.put("request", req);
            StringWriter sw = new StringWriter();
            try {
                tmpl.doTemplate(new GroovyTemplateBinding((Writer)sw, binding));
            }
            catch (IOException e) {
                throw new ScriptRuntimeException((Throwable)e);
            }
            return sw.toString();
        }

        public String backUrlAfterConnect(RequestContext req) {
            return this.doTmpl(this.backUrlAfterConnectTmpl, req);
        }

        public String createRedirectUri(RequestContext req, String actionName) {
            HttpServletRequest httpReq = (HttpServletRequest)req.getAttribute("servletRequest");
            StringBuilder sb = new StringBuilder();
            if (httpReq.isSecure()) {
                sb.append("https://");
            } else {
                sb.append("http://");
            }
            sb.append(httpReq.getServerName());
            int port = httpReq.getServerPort();
            if (httpReq.isSecure() && port != 443 || !httpReq.isSecure() && port != 80) {
                sb.append(':').append(port);
            }
            sb.append(TemplateUtil.getTenantContextPath());
            sb.append("/").append(actionName);
            if (!"DEFAULT".equals(MetaOpenIdConnect.this.getName())) {
                sb.append("/").append(MetaOpenIdConnect.this.getName());
            }
            return sb.toString();
        }

        public OIDCState newOIDCState(String backUrlAfterAuth, String redirectUri, String errorTemplateName) {
            this.checkState();
            OIDCState state = new OIDCState();
            state.setToken(RandomHolder.randomForState.secureRandomToken());
            state.setBackUrlAfterAuth(backUrlAfterAuth);
            state.setIssuer(MetaOpenIdConnect.this.issuer);
            state.setRedirectUri(redirectUri);
            state.setErrorTemplateName(errorTemplateName);
            if (MetaOpenIdConnect.this.useNonce) {
                state.setNonce(RandomHolder.randomForNonce.secureRandomToken());
            }
            if (MetaOpenIdConnect.this.enablePKCE) {
                state.setCodeVerifier(RandomHolder.randomForCodeVerifier.secureRandomToken());
            }
            return state;
        }

        private boolean validateState(OIDCState state, String stateToken, String iss, String redirectUri) {
            if (state == null || stateToken == null) {
                return false;
            }
            if (!state.getRedirectUri().equals(redirectUri)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("redirectUri unmatch:expected=" + state.getRedirectUri() + ", actual=" + redirectUri);
                }
                return false;
            }
            if (!stateToken.equals(state.getToken())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("state unmatch:expected=" + state.getToken() + ", actual=" + stateToken);
                }
                return false;
            }
            if (MetaOpenIdConnect.this.issParameterSupported && !state.getIssuer().equals(iss)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("issuer unmatch:expected=" + state.getIssuer() + ", actual=" + iss);
                }
                return false;
            }
            return true;
        }

        public OIDCValidateResult validate(OIDCCredential credential) {
            Map<String, Object> userInfo;
            this.checkState();
            if (!this.validateState(credential.getState(), credential.getStateToken(), credential.getIss(), credential.getRedirectUri())) {
                return new OIDCValidateResult("invalid_state", "Invalid client state.", null, null);
            }
            Map<String, Object> ret = this.opEndpoint.token(MetaOpenIdConnect.this.clientAuthenticationType, MetaOpenIdConnect.this.clientId, this.clientSecret, credential.getCode(), credential.getRedirectUri(), credential.getState().getCodeVerifier());
            String idTokenJwt = null;
            String tokenType = null;
            String accessToken = null;
            Long expiresIn = null;
            String refreshToken = null;
            String error = null;
            String errorDescription = null;
            String errorUri = null;
            String scope = null;
            Jwt idToken = null;
            HashSet<String> scopeSet = null;
            error = (String)ret.get("error");
            if (error != null) {
                errorDescription = (String)ret.get("error_description");
                errorUri = (String)ret.get("error_uri");
                return new OIDCValidateResult(error, errorDescription, errorUri, null);
            }
            idTokenJwt = (String)ret.get("id_token");
            tokenType = (String)ret.get("token_type");
            accessToken = (String)ret.get("access_token");
            Number expiresInNum = (Number)ret.get("expires_in");
            if (expiresInNum != null) {
                expiresIn = expiresInNum.longValue();
            }
            refreshToken = (String)ret.get("refresh_token");
            scope = (String)ret.get("scope");
            if (tokenType == null || accessToken == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("invalid token response:" + ret);
                }
                return new OIDCValidateResult("invalid_token_response", "Invalid Token Response.token_type and access_token required.", null, null);
            }
            if (!"Bearer".equalsIgnoreCase(tokenType)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("received token type is unknown:" + tokenType);
                }
                return new OIDCValidateResult("unknown_token_type", "The token type is unknown.", null, null);
            }
            scopeSet = new HashSet<String>();
            if (scope != null) {
                scopeSet.addAll(Arrays.asList(scope.split(" ")));
                if (!this.scopeParamSet.equals(scopeSet)) {
                    return new OIDCValidateResult("scope_not_granted", "The requested scope is not granted.", null, null);
                }
            } else {
                scopeSet = (Set)this.scopeParamSet.clone();
            }
            try {
                idToken = this.decodeIdToken(idTokenJwt);
                if (logger.isDebugEnabled()) {
                    logger.debug("received id token:hader=" + idToken.getHeader() + ", payload=" + idToken.getClaims());
                }
                this.validateIdToken(idToken, accessToken, credential);
            }
            catch (RuntimeException e) {
                return new OIDCValidateResult("invalid_id_token", "Invalid IdToken.", null, e);
            }
            HashMap<String, Object> claims = new HashMap<String, Object>(idToken.getClaims());
            if (MetaOpenIdConnect.this.userInfoEndpoint != null && (userInfo = this.opEndpoint.userInfo(tokenType, accessToken)) != null) {
                claims.putAll(userInfo);
            }
            return new OIDCValidateResult((String)claims.get("sub"), (String)claims.get(MetaOpenIdConnect.this.subjectNameClaim), claims, tokenType, accessToken, expiresIn, refreshToken, scopeSet);
        }

        private Jwt decodeIdToken(String idTokenJwt) {
            int index2;
            if (MetaOpenIdConnect.this.validateSign) {
                JwtProcessor jwtp = JwtProcessor.getInstance();
                return jwtp.decode(idTokenJwt, this.opService.getAllowedClockSkewMinutes(), kid -> this.jwks.get((String)kid));
            }
            int index1 = idTokenJwt.indexOf(46);
            if (index1 == (index2 = idTokenJwt.indexOf(46, index1 + 1)) || index2 != idTokenJwt.lastIndexOf(46)) {
                throw new InvalidJwtException("invalid JWT format");
            }
            Map header = null;
            Map claims = null;
            try {
                String headerPart = new String(Base64.getUrlDecoder().decode(idTokenJwt.substring(0, index1)), "UTF-8");
                String payload = new String(Base64.getUrlDecoder().decode(idTokenJwt.substring(index1 + 1, index2)), "UTF-8");
                header = (Map)this.opService.getObjectMapper().readValue(headerPart, (TypeReference)new TypeReference<Map<String, Object>>(){});
                claims = (Map)this.opService.getObjectMapper().readValue(payload, (TypeReference)new TypeReference<Map<String, Object>>(){});
                long now = System.currentTimeMillis();
                Number exp = (Number)claims.get("exp");
                if (exp != null && now >= TimeUnit.SECONDS.toMillis(exp.longValue()) + TimeUnit.MINUTES.toMillis(this.opService.getAllowedClockSkewMinutes())) {
                    throw new InvalidJwtException("JWT expired");
                }
                return new Jwt(header, claims);
            }
            catch (JsonProcessingException | UnsupportedEncodingException e) {
                throw new InvalidJwtException(e);
            }
        }

        private void validateIdToken(Jwt idToken, String accessToken, OIDCCredential cre) {
            String iss = (String)idToken.getClaims().get("iss");
            if (iss == null) {
                throw new InvalidJwtException("iss required");
            }
            if (!iss.equals(cre.getState().getIssuer())) {
                throw new InvalidJwtException("iss unmatch");
            }
            String sub = (String)idToken.getClaims().get("sub");
            if (sub == null) {
                throw new InvalidJwtException("sub required");
            }
            Object aud = idToken.getClaims().get("aud");
            if (aud == null) {
                throw new InvalidJwtException("aud required");
            }
            if (aud instanceof String ? !((String)aud).equals(MetaOpenIdConnect.this.clientId) : !((List)aud).contains(MetaOpenIdConnect.this.clientId)) {
                throw new InvalidJwtException("aud unmatch");
            }
            Number exp = (Number)idToken.getClaims().get("exp");
            if (exp == null) {
                throw new InvalidJwtException("exp required");
            }
            Number iat = (Number)idToken.getClaims().get("iat");
            if (iat == null) {
                throw new InvalidJwtException("iat required");
            }
            if (cre.getState().getCreateTime() > TimeUnit.SECONDS.toMillis(iat.longValue()) + TimeUnit.MINUTES.toMillis(this.opService.getAllowedClockSkewMinutes())) {
                throw new InvalidJwtException("invalid iat");
            }
            if (cre.getState().getNonce() != null) {
                String nonce = (String)idToken.getClaims().get("nonce");
                if (nonce == null) {
                    throw new InvalidJwtException("nonce required");
                }
                if (!nonce.equals(cre.getState().getNonce())) {
                    throw new InvalidJwtException("invalid nonce");
                }
            }
            String azp = (String)idToken.getClaims().get("azp");
            if (aud instanceof List && azp == null) {
                throw new InvalidJwtException("azp required");
            }
            if (azp != null && !azp.equals(MetaOpenIdConnect.this.clientId)) {
                throw new InvalidJwtException("invalid azp");
            }
            String atHash = (String)idToken.getClaims().get("at_hash");
            if (atHash != null && !atHash.equals(OAuthUtil.atHash(accessToken, (String)idToken.getHeader().get("alg")))) {
                throw new InvalidJwtException("invalid at_hash");
            }
            String cHash = (String)idToken.getClaims().get("c_hash");
            if (cHash != null && !cHash.equals(OAuthUtil.cHash(cre.getCode(), (String)idToken.getHeader().get("alg")))) {
                throw new InvalidJwtException("invalid c_hash");
            }
        }

        public String authorizeUrl(OIDCState state) {
            StringBuilder url = new StringBuilder();
            url.append(MetaOpenIdConnect.this.authorizationEndpoint);
            if (MetaOpenIdConnect.this.authorizationEndpoint.indexOf(63) > -1) {
                if (MetaOpenIdConnect.this.authorizationEndpoint.charAt(MetaOpenIdConnect.this.authorizationEndpoint.length() - 1) != '?') {
                    url.append("&");
                }
            } else {
                url.append("?");
            }
            url.append("client_id").append("=").append(OAuthUtil.encodeRfc3986(MetaOpenIdConnect.this.clientId));
            url.append("&");
            url.append("response_type").append("=").append("code");
            url.append("&");
            url.append("scope").append("=").append(OAuthUtil.encodeRfc3986(this.scopeParamValue));
            url.append("&");
            url.append("redirect_uri").append("=").append(OAuthUtil.encodeRfc3986(state.getRedirectUri()));
            url.append("&");
            url.append("state").append("=").append(OAuthUtil.encodeRfc3986(state.getToken()));
            if (MetaOpenIdConnect.this.responseMode != null) {
                String rmStr;
                url.append("&");
                if (MetaOpenIdConnect.this.responseMode == ResponseMode.FORM_POST) {
                    rmStr = "form_post";
                } else if (MetaOpenIdConnect.this.responseMode == ResponseMode.QUERY) {
                    rmStr = "query";
                } else {
                    throw new IllegalArgumentException();
                }
                url.append("response_mode").append("=").append(OAuthUtil.encodeRfc3986(rmStr));
            }
            if (MetaOpenIdConnect.this.useNonce) {
                url.append("&");
                url.append("nonce").append("=").append(OAuthUtil.encodeRfc3986(state.getNonce()));
            }
            if (MetaOpenIdConnect.this.enablePKCE) {
                url.append("&");
                url.append("code_challenge_method").append("=").append("S256");
                url.append("&");
                url.append("code_challenge").append("=").append(OAuthUtil.calcCodeChallenge("S256", state.getCodeVerifier()));
            }
            return url.toString();
        }

        public void connect(String userOid, OIDCValidateResult vr) {
            this.connect(userOid, vr.getSubjectId(), vr.getSubjectName());
        }

        public void connect(String userOid, String subjectId, String subjectName) {
            GenericEntity e = new GenericEntity("mtp.auth.oidc.OpenIdProviderAccount");
            e.setValue("openIdConnectDefinitionName", (Object)MetaOpenIdConnect.this.getName());
            e.setValue("subjectId", (Object)subjectId);
            e.setValue("subjectName", (Object)subjectName);
            e.setValue("user", (Object)new User(userOid, null, false));
            AuthContext.doPrivileged(() -> this.em.insert((Entity)e));
        }

        public void disconnect(String userOid) {
            AuthContext.doPrivileged(() -> {
                Query q = new Query().select(new Object[]{"oid"}).from("mtp.auth.oidc.OpenIdProviderAccount").where((Condition)new And(new Condition[]{new Equals("userOid", (Object)userOid), new Equals("openIdConnectDefinitionName", (Object)MetaOpenIdConnect.this.getName())}));
                Entity e = (Entity)this.em.searchEntity(q).getFirst();
                if (e != null) {
                    this.em.delete(e, new DeleteOption());
                }
            });
        }

        public boolean isAllowedOnPolicy(MetaAuthenticationPolicy.AuthenticationPolicyRuntime userPolicy) {
            if (userPolicy.getMetaData().getOpenIdConnectDefinition() != null) {
                for (String oidcName : userPolicy.getMetaData().getOpenIdConnectDefinition()) {
                    if (this.getMetaData().getName().equals(oidcName)) {
                        return true;
                    }
                    int ai = oidcName.indexOf(42);
                    if (ai < 0) continue;
                    String path = oidcName.substring(0, ai);
                    if (!this.getMetaData().getName().startsWith(path)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class RandomHolder {
        static final SecureRandomGenerator randomForState = ((SecureRandomService)ServiceRegistry.getRegistry().getService(SecureRandomService.class)).createGenerator("stateTokenGenerator");
        static final SecureRandomGenerator randomForNonce = ((SecureRandomService)ServiceRegistry.getRegistry().getService(SecureRandomService.class)).createGenerator("nonceGenerator");
        static final SecureRandomGenerator randomForCodeVerifier = ((SecureRandomService)ServiceRegistry.getRegistry().getService(SecureRandomService.class)).createGenerator("codeVerifierGenerator");

        private RandomHolder() {
        }
    }
}

