/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.preview;

import java.sql.Timestamp;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.SessionContext;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.web.WebUtil;

public class PreviewHandler {
    public static final String CURRENT_TIMESTAMP = "org.iplass.mtp.currentTimestamp";

    public void init(RequestContext requestCotnext) {
        Timestamp ts;
        SessionContext session;
        ExecuteContext exec = ExecuteContext.getCurrentContext();
        if (this.isUsePreview(exec) && (session = requestCotnext.getSession(false)) != null && (ts = (Timestamp)session.getAttribute(CURRENT_TIMESTAMP)) != null) {
            exec.setCurrentTimestamp(ts);
        }
    }

    public boolean isPreview(RequestContext requestCotnext) {
        Timestamp ts;
        SessionContext session;
        return this.isUsePreview(ExecuteContext.getCurrentContext()) && (session = requestCotnext.getSession(false)) != null && (ts = (Timestamp)session.getAttribute(CURRENT_TIMESTAMP)) != null;
    }

    public Timestamp getPreviewDate(RequestContext requestContext) {
        SessionContext session = requestContext.getSession(false);
        if (session != null) {
            return (Timestamp)session.getAttribute(CURRENT_TIMESTAMP);
        }
        return null;
    }

    public void setPreviewDate(Timestamp ts, RequestContext requestContext) {
        if (this.isUsePreview(ExecuteContext.getCurrentContext())) {
            SessionContext session = requestContext.getSession();
            session.setAttribute(CURRENT_TIMESTAMP, (Object)ts);
        }
    }

    private boolean isUsePreview(ExecuteContext exec) {
        if (exec.getCurrentTenant() != null) {
            return WebUtil.getTenantWebInfo(exec.getCurrentTenant()).isUsePreview();
        }
        return false;
    }
}

