/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.fileupload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.servlet.ServletContext;
import org.apache.commons.fileupload.util.Streams;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.command.UploadFileHandle;
import org.iplass.mtp.command.UploadFileSizeOverException;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebProcessRuntimeException;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.impl.web.fileupload.FileScanner;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadFileHandleImpl
implements UploadFileHandle {
    private static final Logger logger = LoggerFactory.getLogger(UploadFileHandleImpl.class);
    private static WebFrontendService webFront = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
    private File tempFile;
    private String fileName;
    private String type;
    private long size;
    private boolean isSizeOver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UploadFileHandleImpl toUploadFileHandle(InputStream is, String fileName, String type, ServletContext servletContext, long maxSize) throws IOException {
        try {
            UploadFileHandleImpl value = null;
            File tempDir = null;
            tempDir = webFront.getTempFileDir() == null ? (File)servletContext.getAttribute("javax.servlet.context.tempdir") : new File(webFront.getTempFileDir());
            fileName = UploadFileHandleImpl.delPath(fileName);
            if (fileName != null && fileName.length() != 0) {
                String ext = ".tmp";
                File tempFile = null;
                long size = 0L;
                try {
                    tempFile = File.createTempFile("tmp", ext, tempDir);
                    try (FileOutputStream fos = new FileOutputStream(tempFile);){
                        size = Streams.copy((InputStream)is, (OutputStream)fos, (boolean)true);
                    }
                    FileScanner scanHandle = webFront.getUploadFileScanner();
                    if (scanHandle != null) {
                        scanHandle.scan(tempFile.getAbsolutePath());
                        if (!tempFile.exists()) {
                            throw new WebProcessRuntimeException(fileName + " is a file infected with the virus.");
                        }
                    }
                }
                catch (IOException | RuntimeException e) {
                    if (tempFile != null) {
                        try {
                            Files.delete(tempFile.toPath());
                        }
                        catch (IOException ee) {
                            logger.warn("can not delete temp file:" + fileName + ", cause:" + ee, (Throwable)ee);
                        }
                    }
                    throw e;
                }
                value = maxSize != -1L && size > maxSize ? new UploadFileHandleImpl(tempFile, fileName, type, size, true) : new UploadFileHandleImpl(tempFile, fileName, type, size, false);
            }
            UploadFileHandleImpl uploadFileHandleImpl = value;
            return uploadFileHandleImpl;
        }
        finally {
            block29: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block29;
                        logger.debug("can not close request's multipart inputstream:" + fileName + ", " + e, (Throwable)e);
                    }
                }
            }
        }
    }

    private static String delPath(String fileName) {
        if (fileName.contains("\\")) {
            fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
        }
        if (fileName.contains("/")) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        if (fileName.contains("\n") || fileName.contains("\r") || fileName.contains("\u0000")) {
            throw new RuntimeException("contains \\n,\\r,\\0");
        }
        return fileName;
    }

    UploadFileHandleImpl(File tempFile, String fileName, String type, long size, boolean isSizeOver) {
        this.tempFile = tempFile;
        this.fileName = fileName;
        this.type = type;
        this.size = size;
        this.isSizeOver = isSizeOver;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getType() {
        return this.type;
    }

    public BinaryReference toBinaryReference() {
        if (this.isSizeOver) {
            throw new UploadFileSizeOverException(WebResourceBundleUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.maxFileSize", new Object[0]));
        }
        if (webFront.isExecMagicByteCheck()) {
            webFront.getMagicByteChecker().checkMagicByte(this.tempFile, this.type, this.fileName);
        }
        if (!this.tempFile.exists()) {
            logger.warn("upload file is externally deleted. maybe contains virus. fileName:" + this.fileName);
            return null;
        }
        EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);
        return em.createBinaryReference(this.tempFile, this.fileName, this.type);
    }

    public long getSize() {
        return this.size;
    }

    public InputStream getInputStream() {
        if (this.isSizeOver) {
            throw new UploadFileSizeOverException(WebResourceBundleUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.maxFileSize", new Object[0]));
        }
        if (webFront.isExecMagicByteCheck()) {
            webFront.getMagicByteChecker().checkMagicByte(this.tempFile, this.type, this.fileName);
        }
        try {
            return new FileInputStream(this.tempFile);
        }
        catch (FileNotFoundException e) {
            logger.warn("upload file is externally deleted. maybe contains virus.", (Throwable)e);
            return null;
        }
    }

    public boolean isSizeOver() {
        return this.isSizeOver;
    }

    public Path copyTo(Path target, CopyOption ... options) {
        if (this.isSizeOver) {
            throw new UploadFileSizeOverException(WebResourceBundleUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.maxFileSize", new Object[0]));
        }
        if (webFront.isExecMagicByteCheck()) {
            webFront.getMagicByteChecker().checkMagicByte(this.tempFile, this.type, this.fileName);
        }
        try {
            return Files.copy(this.tempFile.toPath(), target, options);
        }
        catch (IOException e) {
            throw new WebProcessRuntimeException(e);
        }
    }

    public Path moveTo(Path target, CopyOption ... options) {
        if (this.isSizeOver) {
            throw new UploadFileSizeOverException(WebResourceBundleUtil.resourceString("impl.web.fileupload.UploadFileHandleImpl.maxFileSize", new Object[0]));
        }
        if (webFront.isExecMagicByteCheck()) {
            webFront.getMagicByteChecker().checkMagicByte(this.tempFile, this.type, this.fileName);
        }
        try {
            return Files.move(this.tempFile.toPath(), target, options);
        }
        catch (IOException e) {
            throw new WebProcessRuntimeException(e);
        }
    }

    public void deleteTempFile() {
        if (this.tempFile != null) {
            try {
                Files.delete(this.tempFile.toPath());
            }
            catch (Exception e) {
                logger.warn("can not delete temp file:" + this.fileName + ", cause:" + e, (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.fileName;
    }
}

