/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.csv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.async.AsyncTaskFuture;
import org.iplass.mtp.async.AsyncTaskInfo;
import org.iplass.mtp.async.AsyncTaskInfoSearchCondtion;
import org.iplass.mtp.async.AsyncTaskManager;
import org.iplass.mtp.async.AsyncTaskOption;
import org.iplass.mtp.async.ExceptionHandlingMode;
import org.iplass.mtp.async.TaskStatus;
import org.iplass.mtp.async.TaskTimeoutException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityDuplicateValueException;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityValidationException;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.csv.CsvUploadStatus;
import org.iplass.mtp.impl.csv.CsvUploadTask;
import org.iplass.mtp.impl.csv.EntityCsvReaderForCheck;
import org.iplass.mtp.impl.csv.TransactionType;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.impl.entity.csv.EntityCsvReader;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Propagation;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvUploadService
implements Service {
    private static Logger logger = LoggerFactory.getLogger(CsvUploadService.class);
    private static final String CSV_UPLOAD_QUEUE = "csvupload";
    private static final String ENCODE = "UTF-8";
    private int showErrorLimitCount;
    private boolean mustOrderByWithLimit;
    private EntityManager em = null;
    private EntityDefinitionManager edm = null;

    public void init(Config config) {
        this.em = (EntityManager)ManagerLocator.manager(EntityManager.class);
        this.edm = (EntityDefinitionManager)ManagerLocator.manager(EntityDefinitionManager.class);
        this.showErrorLimitCount = (Integer)config.getValue("showErrorLimitCount", Integer.class, (Object)100);
        this.mustOrderByWithLimit = (Boolean)config.getValue("mustOrderByWithLimit", Boolean.class, (Object)false);
    }

    public void destroy() {
    }

    public int getShowErrorLimitCount() {
        return this.showErrorLimitCount;
    }

    public boolean isMustOrderByWithLimit() {
        return this.mustOrderByWithLimit;
    }

    public void validate(InputStream is, String defName, boolean withReferenceVersion) {
        this.validate(is, defName, withReferenceVersion, this.showErrorLimitCount);
    }

    public void validate(InputStream is, String defName, boolean withReferenceVersion, int errorLimit) {
        EntityDefinition ed = this.edm.get(defName);
        try (EntityCsvReaderForCheck reader = new EntityCsvReaderForCheck(ed, is, ENCODE, errorLimit);){
            reader.withReferenceVersion(withReferenceVersion);
            reader.check();
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityCsvException("CE0001", CsvUploadService.resourceString("impl.csv.CsvUploadService.invalidFileMsg", new Object[0]));
        }
        catch (EntityCsvException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ApplicationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EntityCsvException("CE9000", e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EntityCsvException("CE9000", CsvUploadService.resourceString("impl.csv.CsvUploadService.errReadFile", new Object[0]));
        }
    }

    @Deprecated
    public CsvUploadStatus upload(InputStream is, String defName, String uniqueKey, TransactionType transactionType, int commitLimit, boolean withReferenceVersion, boolean deleteSpecificVersion) {
        return this.upload(is, defName, uniqueKey, false, false, false, null, null, transactionType, commitLimit, withReferenceVersion, deleteSpecificVersion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CsvUploadStatus upload(InputStream is, String defName, String uniqueKey, boolean isDenyInsert, boolean isDenyUpdate, boolean isDenyDelete, Set<String> insertProperties, Set<String> updateProperties, TransactionType transactionType, int commitLimit, boolean withReferenceVersion, boolean deleteSpecificVersion) {
        CsvUploadStatus result = new CsvUploadStatus();
        EntityDefinition ed = this.edm.get(defName);
        try (EntityCsvReader reader = new EntityCsvReader(ed, is, ENCODE);){
            reader.withReferenceVersion(withReferenceVersion);
            Transaction.with((Propagation)Propagation.SUPPORTS, t -> {
                int readCount = 0;
                int insertCount = 0;
                int updateCount = 0;
                int deleteCount = 0;
                List properties = reader.properties();
                boolean useCtrl = reader.isUseCtrl();
                Set<String> updatablePropperties = null;
                HashMap<Object, String> keyValueMap = new HashMap<Object, String>();
                Iterator iterator = reader.iterator();
                while (iterator.hasNext()) {
                    ImportFunction func = new ImportFunction(this.em).ed(ed).iterator(iterator).isDenyInsert(isDenyInsert).isDenyUpdate(isDenyUpdate).isDenyDelete(isDenyDelete).insertProperties(insertProperties).updateProperties(updateProperties).transactionType(transactionType).commitLimit(commitLimit).useCtrl(useCtrl).uniqueKey(uniqueKey).properties(properties).updatablePropperties(updatablePropperties).keyValueMap(keyValueMap).deleteSpecificVersion(deleteSpecificVersion);
                    ApplicationException ex = null;
                    try {
                        Transaction.requiresNew((Consumer)func);
                        updatablePropperties = func.updatablePropperties();
                    }
                    catch (EntityDuplicateValueException e) {
                        ex = new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.rowMsg", readCount + func.readCount()) + CsvUploadService.resourceString("impl.csv.CsvUploadService.overlapMsg", new Object[0]));
                    }
                    catch (EntityValidationException e) {
                        String errorMessage = " ";
                        if (e.getValidateResults() != null) {
                            for (ValidateError ve : e.getValidateResults()) {
                                errorMessage = errorMessage + ve.getPropertyName() + " : " + ve.getErrorMessages() + ", ";
                            }
                        }
                        ex = new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.rowMsg", readCount + func.readCount()) + CsvUploadService.resourceString("impl.csv.CsvUploadService.validationMsg", new Object[0]) + errorMessage);
                    }
                    catch (Exception e) {
                        ex = new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.rowMsg", readCount + func.readCount()) + e.getMessage());
                    }
                    finally {
                        readCount += func.readCount();
                        insertCount += func.insertCount();
                        updateCount += func.updateCount();
                        deleteCount += func.deleteCount();
                    }
                    if (ex == null) continue;
                    result.setInsertCount(insertCount);
                    result.setUpdateCount(updateCount);
                    result.setDeleteCount(deleteCount);
                    throw ex;
                }
                result.setInsertCount(insertCount);
                result.setUpdateCount(updateCount);
                result.setDeleteCount(deleteCount);
                result.setStatus(TaskStatus.COMPLETED);
            });
            CsvUploadStatus csvUploadStatus = result;
            return csvUploadStatus;
        }
        catch (UnsupportedEncodingException e) {
            return this.asFailedResult(result, "CE0001", CsvUploadService.resourceString("impl.csv.CsvUploadService.invalidFileMsg", new Object[0]));
        }
        catch (EntityCsvException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.asFailedResult(result, e.getCode(), e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.asFailedResult(result, "CE9000", e.getMessage());
        }
    }

    private CsvUploadStatus asFailedResult(CsvUploadStatus result, String code, String message) {
        result.setCode(code);
        result.setMessage(message);
        result.setStatus(TaskStatus.ABORTED);
        return result;
    }

    @Deprecated
    public void asyncUpload(InputStream is, String fileName, String defName, String parameter, String uniqueKey, TransactionType transactionType, int commitLimit, boolean withReferenceVersion, boolean deleteSpecificVersion) {
        this.asyncUpload(is, fileName, defName, parameter, uniqueKey, false, false, false, null, null, transactionType, commitLimit, withReferenceVersion, deleteSpecificVersion);
    }

    public void asyncUpload(InputStream is, String fileName, String defName, String parameter, String uniqueKey, boolean isDenyInsert, boolean isDenyUpdate, boolean isDenyDelete, Set<String> insertProperties, Set<String> updateProperties, TransactionType transactionType, int commitLimit, boolean withReferenceVersion, boolean deleteSpecificVersion) {
        Path destPath = this.copyUploadFile(is);
        CsvUploadTask task = new CsvUploadTask(destPath.toString(), fileName, DateUtil.getCurrentTimestamp().getTime(), defName, parameter, uniqueKey, isDenyInsert, isDenyUpdate, isDenyDelete, insertProperties, updateProperties, transactionType, commitLimit, withReferenceVersion, deleteSpecificVersion);
        AsyncTaskOption option = new AsyncTaskOption();
        option.setExceptionHandlingMode(ExceptionHandlingMode.ABORT);
        option.setGroupingKey(AuthContext.getCurrentContext().getUser().getOid());
        option.setQueue(CSV_UPLOAD_QUEUE);
        option.setReturnResult(true);
        ((AsyncTaskManager)ManagerLocator.manager(AsyncTaskManager.class)).execute(option, (Callable)task);
    }

    private Path copyUploadFile(InputStream is) {
        WebFrontendService webFront = (WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class);
        File tempDir = null;
        if (webFront.getTempFileDir() == null) {
            WebRequestStack reqStack = WebRequestStack.getCurrent();
            if (reqStack != null && reqStack.getRequest() != null) {
                tempDir = (File)reqStack.getRequest().getServletContext().getAttribute("javax.servlet.context.tempdir");
            }
        } else {
            tempDir = new File(webFront.getTempFileDir());
        }
        Path distFile = null;
        try {
            distFile = Files.createTempFile(tempDir.toPath(), "mtp", ".csv", new FileAttribute[0]);
            Files.copy(is, distFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | RuntimeException e) {
            if (distFile != null) {
                try {
                    Files.deleteIfExists(distFile);
                }
                catch (IOException e1) {
                    logger.warn("Fail to delete a Temporary's File.", (Throwable)e1);
                }
            }
            throw new EntityCsvException((Throwable)e);
        }
        return distFile;
    }

    public List<CsvUploadStatus> getStatus() {
        ArrayList<CsvUploadStatus> taskStatusList = new ArrayList<CsvUploadStatus>();
        AsyncTaskInfoSearchCondtion cond = new AsyncTaskInfoSearchCondtion();
        cond.setQueue(CSV_UPLOAD_QUEUE);
        cond.setGroupingKey(AuthContext.getCurrentContext().getUser().getOid());
        cond.setWithHistory(true);
        AsyncTaskManager atm = (AsyncTaskManager)ManagerLocator.manager(AsyncTaskManager.class);
        List infoList = atm.searchAsyncTaskInfo(cond);
        for (AsyncTaskInfo info : infoList) {
            AsyncTaskInfo detail = atm.loadAsyncTaskInfo(info.getTaskId(), CSV_UPLOAD_QUEUE);
            CsvUploadStatus result = null;
            if (TaskStatus.RETURNED.equals((Object)info.getStatus())) {
                try {
                    AsyncTaskFuture future = atm.getResult(info.getTaskId(), CSV_UPLOAD_QUEUE);
                    result = (CsvUploadStatus)future.get();
                }
                catch (Exception e) {
                    throw new SystemException((Throwable)e);
                }
            } else if (detail.getResult() != null) {
                if (detail.getResult() instanceof CsvUploadStatus) {
                    result = (CsvUploadStatus)detail.getResult();
                } else if (detail.getResult() instanceof TaskTimeoutException) {
                    result = new CsvUploadStatus();
                    result.setStatus(TaskStatus.ABORTED);
                    result.setMessage(CsvUploadService.resourceString("impl.csv.CsvUploadService.timeoutMsg", new Object[0]));
                }
            }
            if (result == null) {
                result = new CsvUploadStatus();
                result.setStatus(info.getStatus());
            }
            CsvUploadTask task = (CsvUploadTask)detail.getTask();
            result.setFileName(task.getFileName());
            result.setUploadDateTime(task.getUploadDateTime());
            result.setDefName(task.getDefName());
            result.setParameter(task.getParameter());
            taskStatusList.add(result);
        }
        return taskStatusList;
    }

    private static String resourceString(String key, Object ... arguments) {
        return WebResourceBundleUtil.resourceString(key, arguments);
    }

    private static class ImportFunction
    implements Consumer<Transaction> {
        private int readCount = 0;
        private int insertCount = 0;
        private int updateCount = 0;
        private int deleteCount = 0;
        private EntityManager em;
        private EntityDefinition ed;
        private Iterator<Entity> iterator;
        private TransactionType transactionType;
        private boolean useCtrl;
        private boolean isDenyInsert;
        private boolean isDenyUpdate;
        private boolean isDenyDelete;
        private Set<String> insertProperties;
        private Set<String> updateProperties;
        private int commitLimit;
        private String uniqueKey = "oid";
        private List<String> properties;
        private Set<String> updatablePropperties;
        private Map<Object, String> keyValueMap;
        private boolean deleteSpecificVersion;

        public ImportFunction(EntityManager em) {
            this.em = em;
        }

        public ImportFunction ed(EntityDefinition ed) {
            this.ed = ed;
            return this;
        }

        public ImportFunction iterator(Iterator<Entity> iterator) {
            this.iterator = iterator;
            return this;
        }

        public ImportFunction isDenyInsert(boolean isDenyInsert) {
            this.isDenyInsert = isDenyInsert;
            return this;
        }

        public ImportFunction isDenyUpdate(boolean isDenyUpdate) {
            this.isDenyUpdate = isDenyUpdate;
            return this;
        }

        public ImportFunction isDenyDelete(boolean isDenyDelete) {
            this.isDenyDelete = isDenyDelete;
            return this;
        }

        public ImportFunction insertProperties(Set<String> insertProperties) {
            this.insertProperties = insertProperties;
            return this;
        }

        public ImportFunction updateProperties(Set<String> updateProperties) {
            this.updateProperties = updateProperties;
            return this;
        }

        public ImportFunction transactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public ImportFunction commitLimit(int commitLimit) {
            this.commitLimit = commitLimit;
            return this;
        }

        public ImportFunction useCtrl(boolean useCtrl) {
            this.useCtrl = useCtrl;
            return this;
        }

        public ImportFunction uniqueKey(String uniqueKey) {
            if (uniqueKey != null) {
                this.uniqueKey = uniqueKey;
            }
            return this;
        }

        public ImportFunction properties(List<String> properties) {
            this.properties = properties;
            return this;
        }

        public ImportFunction updatablePropperties(Set<String> updatablePropperties) {
            this.updatablePropperties = updatablePropperties;
            return this;
        }

        public ImportFunction keyValueMap(Map<Object, String> keyValueMap) {
            this.keyValueMap = keyValueMap;
            return this;
        }

        public ImportFunction deleteSpecificVersion(boolean deleteSpecificVersion) {
            this.deleteSpecificVersion = deleteSpecificVersion;
            return this;
        }

        public int readCount() {
            return this.readCount;
        }

        public int insertCount() {
            return this.insertCount;
        }

        public int updateCount() {
            return this.updateCount;
        }

        public int deleteCount() {
            return this.deleteCount;
        }

        public Set<String> updatablePropperties() {
            return this.updatablePropperties;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void accept(Transaction transaction) {
            try {
                block8: while (this.iterator.hasNext()) {
                    if (this.transactionType == TransactionType.DIVISION && this.readCount == this.commitLimit) {
                        return;
                    }
                    Entity entity = this.iterator.next();
                    ++this.readCount;
                    Object uniqueKeyValue = entity.getValue(this.uniqueKey);
                    String ctrlCode = (String)entity.getValue("_useCtrl");
                    if (StringUtil.isEmpty((String)ctrlCode)) {
                        ctrlCode = "M";
                    }
                    if (this.useCtrl && ctrlCode.equals("D")) {
                        if (this.isDenyDelete) {
                            throw new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.denyDeleteError", new Object[0]));
                        }
                        DeleteTargetVersion deleteTargetVersion = DeleteTargetVersion.ALL;
                        SearchResult searchResult = null;
                        if (this.ed.getVersionControlType() != VersionControlType.NONE && this.deleteSpecificVersion && entity.getVersion() != null) {
                            searchResult = this.em.searchEntity(this.onVersionQuery(this.ed.getName(), this.uniqueKey, uniqueKeyValue, entity.getVersion()));
                            deleteTargetVersion = DeleteTargetVersion.SPECIFIC;
                        } else {
                            searchResult = this.em.searchEntity(this.noVersionQuery(this.ed.getName(), this.uniqueKey, uniqueKeyValue));
                        }
                        if (searchResult.getFirst() == null) continue;
                        entity.setOid(((Entity)searchResult.getFirst()).getOid());
                        this.em.delete(entity, new DeleteOption(false, deleteTargetVersion));
                        ++this.deleteCount;
                        continue;
                    }
                    ExecType execType = this.execType(this.ed, this.uniqueKey, uniqueKeyValue, entity, this.keyValueMap);
                    if (this.useCtrl) {
                        if (execType == ExecType.INSERT && !ctrlCode.equals("I") && !ctrlCode.equals("M")) {
                            throw new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.ctrlFlgUpdateError", new Object[0]));
                        }
                        if (!(execType != ExecType.UPDATE_SPECIFIC && execType != ExecType.UPDATE_VALID && execType != ExecType.UPDATE_NEW || ctrlCode.equals("U") || ctrlCode.equals("M"))) {
                            throw new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.ctrlFlgInsertError", new Object[0]));
                        }
                    }
                    switch (execType) {
                        case INSERT: {
                            if (this.isDenyInsert) {
                                throw new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.denyInsertError", new Object[0]));
                            }
                            if (this.insertProperties != null) {
                                this.properties.stream().filter(property -> !this.insertProperties.contains(property)).forEach(property -> entity.setValue(property, null));
                            }
                            entity.setLockedBy(null);
                            String insertOid = this.em.insert(entity);
                            this.keyValueMap.put(uniqueKeyValue, insertOid);
                            ++this.insertCount;
                            continue block8;
                        }
                        case UPDATE_SPECIFIC: {
                            if (this.isDenyUpdate) {
                                throw new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.denyUpdateError", new Object[0]));
                            }
                            this.em.update(entity, this.updateOption(TargetVersion.SPECIFIC));
                            ++this.updateCount;
                            continue block8;
                        }
                        case UPDATE_VALID: {
                            if (this.isDenyUpdate) {
                                throw new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.denyUpdateError", new Object[0]));
                            }
                            this.em.update(entity, this.updateOption(TargetVersion.CURRENT_VALID));
                            this.keyValueMap.put(uniqueKeyValue, entity.getOid());
                            ++this.updateCount;
                            continue block8;
                        }
                        case UPDATE_NEW: {
                            if (this.isDenyUpdate) {
                                throw new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.denyUpdateError", new Object[0]));
                            }
                            entity.setVersion(null);
                            this.em.update(entity, this.updateOption(TargetVersion.NEW));
                            this.keyValueMap.put(uniqueKeyValue, entity.getOid());
                            ++this.updateCount;
                            continue block8;
                        }
                    }
                }
                return;
                throw new ApplicationException(CsvUploadService.resourceString("impl.csv.CsvUploadService.invalid", new Object[0]));
            }
            catch (Exception e) {
                if (this.transactionType == TransactionType.DIVISION && !transaction.isRollbackOnly()) {
                    transaction.commit();
                    throw e;
                }
                this.insertCount = 0;
                this.updateCount = 0;
                this.deleteCount = 0;
                throw e;
            }
        }

        private ExecType execType(EntityDefinition ed, String uniqueKey, Object uniqueKeyValue, Entity entity, Map<Object, String> keyValueMap) {
            ExecType execType = null;
            if (uniqueKeyValue == null) {
                execType = ExecType.INSERT;
            } else if (ed.getVersionControlType() != VersionControlType.NONE) {
                if (keyValueMap.containsKey(uniqueKeyValue)) {
                    execType = ExecType.UPDATE_NEW;
                    entity.setOid(keyValueMap.get(uniqueKeyValue));
                } else if (entity.getVersion() != null) {
                    Query q = this.onVersionQuery(ed.getName(), "oid", uniqueKeyValue, entity.getVersion());
                    int count = this.em.count(q);
                    if (count > 0) {
                        execType = ExecType.UPDATE_SPECIFIC;
                    } else {
                        SearchResult searchResult = this.em.searchEntity(this.noVersionQuery(ed.getName(), uniqueKey, uniqueKeyValue), new SearchOption().countTotal());
                        if (searchResult.getTotalCount() > 0) {
                            execType = ExecType.UPDATE_NEW;
                            entity.setOid(((Entity)searchResult.getFirst()).getOid());
                        } else {
                            execType = ExecType.INSERT;
                        }
                    }
                } else {
                    SearchResult searchResult = this.em.searchEntity(this.noVersionQuery(ed.getName(), uniqueKey, uniqueKeyValue), new SearchOption().countTotal());
                    if (searchResult.getTotalCount() > 0) {
                        execType = ExecType.UPDATE_NEW;
                        entity.setOid(((Entity)searchResult.getFirst()).getOid());
                    } else {
                        execType = ExecType.INSERT;
                    }
                }
            } else {
                SearchResult searchResult = this.em.searchEntity(this.noVersionQuery(ed.getName(), uniqueKey, uniqueKeyValue), new SearchOption().countTotal());
                if (searchResult.getTotalCount() > 0) {
                    execType = ExecType.UPDATE_VALID;
                    entity.setOid(((Entity)searchResult.getFirst()).getOid());
                } else {
                    execType = ExecType.INSERT;
                }
            }
            return execType;
        }

        private Query noVersionQuery(String defName, String uniqueKey, Object uniqueKeyValue) {
            return new Query().select(new Object[]{"oid"}).from(defName).where((Condition)new Equals(uniqueKey, uniqueKeyValue));
        }

        private Query onVersionQuery(String defName, String uniqueKey, Object uniqueKeyValue, Long version) {
            return new Query().select(new Object[]{"oid"}).from(this.ed.getName()).where((Condition)new And(new Condition[]{new Equals(uniqueKey, uniqueKeyValue), new Equals("version", (Object)version)})).versioned(true);
        }

        private UpdateOption updateOption(TargetVersion targetVersion) {
            UpdateOption option = new UpdateOption(false);
            if (this.updatablePropperties == null) {
                this.updatablePropperties = this.updateProperties != null ? this.updateProperties : this.filterPropperties();
            }
            option.setUpdateProperties(new ArrayList<String>(this.updatablePropperties));
            option.setTargetVersion(targetVersion);
            return option;
        }

        private Set<String> filterPropperties() {
            return this.properties.stream().filter(s -> !s.equals("oid") && !s.equals("version") && !s.equals("updateBy") && !s.equals("updateDate") && !s.equals("lockedBy") && !s.equals("createBy") && !s.equals("createDate") && !s.equals("_useCtrl")).map(s -> this.ed.getProperty(s)).filter(pd -> pd != null).filter(pd -> pd.isUpdatable()).filter(pd -> !(pd instanceof ExpressionProperty) && !(pd instanceof BinaryProperty)).filter(pd -> !(pd instanceof ReferenceProperty) || ((ReferenceProperty)pd).getMappedBy() == null).map(PropertyDefinition::getName).collect(Collectors.toSet());
        }
    }

    private static enum ExecType {
        INSERT,
        UPDATE_SPECIFIC,
        UPDATE_VALID,
        UPDATE_NEW;

    }
}

