/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.vh;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.MetaScope;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.OAuthClientService;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationRequest;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.spi.ServiceRegistry;

public class ConsentViewHelper {
    private static OAuthAuthorizationService authorizationService = (OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class);
    private static OAuthClientService clientService = (OAuthClientService)ServiceRegistry.getRegistry().getService(OAuthClientService.class);
    private AuthorizationRequest authRequest;
    private MetaOAuthAuthorization.OAuthAuthorizationRuntime server;
    private MetaOAuthClient.OAuthClientRuntime client;
    private List<ScopeItem> scopes;

    public ConsentViewHelper(AuthorizationRequest authRequest) {
        this.authRequest = authRequest;
        this.server = (MetaOAuthAuthorization.OAuthAuthorizationRuntime)authorizationService.getRuntimeByName(authRequest.getAuthorizationServerId());
        this.client = (MetaOAuthClient.OAuthClientRuntime)clientService.getRuntimeByName(authRequest.getClientId());
        this.scopes = new ArrayList<ScopeItem>();
        List<MetaScope> msList = this.server.getScopeByName(authRequest.getScopes());
        for (MetaScope ms : msList) {
            this.scopes.add(new ScopeItem(ms));
        }
    }

    public String getClientName() {
        String name = I18nUtil.stringMeta((String)this.client.getMetaData().getDisplayName(), (List)this.client.getMetaData().getLocalizedDisplayNameList());
        if (name == null) {
            name = this.client.getMetaData().getName();
        }
        return name;
    }

    public String getClientUri() {
        return this.client.getMetaData().getClientUri();
    }

    public String getLogoUri() {
        return this.client.getMetaData().getLogoUri();
    }

    public List<String> getContacts() {
        return this.client.getMetaData().getContacts();
    }

    public String getTosUri() {
        return this.client.getMetaData().getTosUri();
    }

    public String getPolicyUri() {
        return this.client.getMetaData().getPolicyUri();
    }

    public String getRequestId() {
        return this.authRequest.getRequestId();
    }

    public List<ScopeItem> getScopes() {
        return this.scopes;
    }

    public static class ScopeItem {
        private MetaScope scope;

        public ScopeItem(MetaScope scope) {
            this.scope = scope;
        }

        public String getName() {
            String str = I18nUtil.stringMeta((String)this.scope.getDisplayName(), this.scope.getLocalizedDisplayNameList());
            if (str == null) {
                str = this.scope.getName();
            }
            return str;
        }

        public String getDescription() {
            return I18nUtil.stringMeta((String)this.scope.getDescription(), this.scope.getLocalizedDescriptionList());
        }
    }
}

