/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template.groovy;

import groovy.lang.Binding;
import java.util.ArrayList;
import java.util.Map;
import javax.el.PropertyNotFoundException;
import org.iplass.mtp.command.beanmapper.MappingError;
import org.iplass.mtp.command.beanmapper.MappingException;
import org.iplass.mtp.command.beanmapper.MappingResult;
import org.iplass.mtp.impl.command.beanmapper.el.ELMapper;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.ValueFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BindContext {
    private static Logger log = LoggerFactory.getLogger(BindContext.class);
    String propertyDelimiter;
    String indexPrefix;
    String indexPostfix;
    String prefix;
    String beanVariableName;
    String mappingResultVariableName;
    Boolean autoDetectErrors = Boolean.TRUE;
    String propertyNameVariableName;
    String propertyValueVariableName;
    String propertyRawValueVariableName;
    String propertyErrorValueVariableName;
    String errorsVariableName;
    Boolean htmlEscape;
    ValueFormatter formatter;
    BindContext parent;
    Object bean;
    String prop;
    MappingResult mappingResult;
    boolean setBean;
    ELMapper elMapper;
    Binding binding;

    BindContext(Map<String, Object> params, BindContext parent) {
        this.setBean = params.containsKey("bean");
        if (!this.setBean && parent != null && parent.setBean) {
            this.parent = parent;
        }
        this.initParam(params);
        this.prop = this.asString(params.get("prop"));
        if (this.setBean) {
            this.bean = params.get("bean");
            this.mappingResult = (MappingResult)params.get("mappingResult");
            this.elMapper = new ELMapper();
            this.elMapper.setTargetBean(this.bean);
            this.exposeBean();
        } else if (this.parent != null) {
            this.bean = this.parent.bean;
            this.elMapper = this.parent.elMapper;
            this.mappingResult = this.parent.mappingResult;
        }
        if (this.prop != null) {
            this.exposeProp();
        }
    }

    public Binding getBinding() {
        return this.binding;
    }

    private String asString(Object val) {
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    private void setVariable(String name, Object value) {
        if (this.binding == null) {
            this.binding = new Binding();
        }
        this.binding.setVariable(name, value);
    }

    private void exposeBean() {
        this.setVariable(this.beanVariableName, this.bean);
        if (this.autoDetectErrors != null && this.autoDetectErrors.booleanValue()) {
            MappingResult mr;
            Exception e;
            WebRequestStack webStack;
            if (this.mappingResult == null && (webStack = WebRequestStack.getCurrent()) != null && (e = (Exception)webStack.getRequestContext().getAttribute("mtp.web.exception")) != null && this.bean == (mr = ((MappingException)e).getResult()).getBean()) {
                this.mappingResult = mr;
            }
            if (this.mappingResult == null) {
                this.mappingResult = new MappingResult(this.bean);
            }
        }
        this.setVariable(this.mappingResultVariableName, this.mappingResult);
    }

    private void exposeProp() {
        if (this.bean != null) {
            Object value;
            block17: {
                String name = this.prop;
                if (this.propertyDelimiter != null) {
                    name = name.replace(".", this.propertyDelimiter);
                }
                if (this.indexPrefix != null) {
                    name = name.replace("[", this.indexPrefix);
                }
                if (this.indexPostfix != null) {
                    name = name.replace("]", this.indexPostfix);
                }
                if (this.prefix != null) {
                    name = this.prefix + name;
                }
                this.setVariable(this.propertyNameVariableName, name);
                this.setVariable(this.propertyErrorValueVariableName, null);
                this.setVariable(this.errorsVariableName, null);
                value = null;
                boolean valResolve = false;
                if (this.mappingResult.hasError()) {
                    MappingError e = this.mappingResult.getError(this.prop);
                    if (e != null) {
                        value = e.getErrorValue();
                        valResolve = true;
                    }
                    ArrayList errMsgs = new ArrayList();
                    Object errorValue = null;
                    for (MappingError me : this.mappingResult.getErrors()) {
                        if (!me.getPropertyPath().startsWith(this.prop)) continue;
                        if (me.getPropertyPath().length() == this.prop.length()) {
                            errMsgs.addAll(me.getErrorMessages());
                            errorValue = me.getErrorValue();
                            continue;
                        }
                        char c = me.getPropertyPath().charAt(this.prop.length());
                        if (c != '.' && c != '[') continue;
                        errMsgs.addAll(me.getErrorMessages());
                    }
                    if (errMsgs.size() > 0) {
                        this.setVariable(this.errorsVariableName, errMsgs);
                        if (errorValue != null && this.htmlEscape.booleanValue()) {
                            this.setVariable(this.propertyErrorValueVariableName, StringUtil.escapeHtml((String)this.formatter.apply(errorValue)));
                        } else {
                            this.setVariable(this.propertyErrorValueVariableName, this.formatter.apply(errorValue));
                        }
                    }
                }
                if (!valResolve) {
                    try {
                        value = this.elMapper.getValue(this.prop);
                    }
                    catch (PropertyNotFoundException e) {
                        if (!log.isDebugEnabled()) break block17;
                        log.debug(this.prop + " not reachable in target bean: " + this.bean + ", cause:" + e.toString());
                    }
                }
            }
            if (value != null && this.htmlEscape.booleanValue()) {
                this.setVariable(this.propertyValueVariableName, StringUtil.escapeHtml((String)this.formatter.apply(value)));
            } else {
                this.setVariable(this.propertyValueVariableName, this.formatter.apply(value));
            }
            this.setVariable(this.propertyRawValueVariableName, value);
        }
    }

    private void initParam(Map<String, Object> params) {
        Boolean adr;
        this.propertyDelimiter = this.asString(params.get("propertyDelimiter"));
        if (this.propertyDelimiter == null && this.parent != null) {
            this.propertyDelimiter = this.parent.propertyDelimiter;
        }
        this.indexPrefix = this.asString(params.get("indexPrefix"));
        if (this.indexPrefix == null && this.parent != null) {
            this.indexPrefix = this.parent.indexPrefix;
        }
        this.indexPostfix = this.asString(params.get("indexPostfix"));
        if (this.indexPostfix == null && this.parent != null) {
            this.indexPostfix = this.parent.indexPostfix;
        }
        this.prefix = this.asString(params.get("prefix"));
        if (this.prefix == null && this.parent != null) {
            this.prefix = this.parent.prefix;
        }
        this.htmlEscape = (Boolean)params.get("htmlEscape");
        if (this.htmlEscape == null) {
            if (this.parent != null) {
                this.htmlEscape = this.parent.htmlEscape;
            }
            if (this.htmlEscape == null) {
                this.htmlEscape = Boolean.TRUE;
            }
        }
        this.formatter = (ValueFormatter)params.get("formatter");
        if (this.formatter == null) {
            if (this.parent != null) {
                this.formatter = this.parent.formatter;
            }
            if (this.formatter == null) {
                this.formatter = ValueFormatter.DEFAULT_FORMATTER;
            }
        }
        if ((adr = (Boolean)params.get("autoDetectErrors")) != null) {
            this.autoDetectErrors = adr;
        }
        this.beanVariableName = this.asString(params.get("beanVariableName"));
        if (this.beanVariableName == null) {
            if (this.parent != null) {
                this.beanVariableName = this.parent.beanVariableName;
            }
            if (this.beanVariableName == null) {
                this.beanVariableName = "bean";
            }
        }
        this.mappingResultVariableName = this.asString(params.get("mappingResultVariableName"));
        if (this.mappingResultVariableName == null) {
            if (this.parent != null) {
                this.mappingResultVariableName = this.parent.mappingResultVariableName;
            }
            if (this.mappingResultVariableName == null) {
                this.mappingResultVariableName = "mappingResult";
            }
        }
        this.propertyNameVariableName = this.asString(params.get("propertyNameVariableName"));
        if (this.propertyNameVariableName == null) {
            if (this.parent != null) {
                this.propertyNameVariableName = this.parent.propertyNameVariableName;
            }
            if (this.propertyNameVariableName == null) {
                this.propertyNameVariableName = "name";
            }
        }
        this.propertyValueVariableName = this.asString(params.get("propertyValueVariableName"));
        if (this.propertyValueVariableName == null) {
            if (this.parent != null) {
                this.propertyValueVariableName = this.parent.propertyValueVariableName;
            }
            if (this.propertyValueVariableName == null) {
                this.propertyValueVariableName = "value";
            }
        }
        this.propertyRawValueVariableName = this.asString(params.get("propertyRawValueVariableName"));
        if (this.propertyRawValueVariableName == null) {
            if (this.parent != null) {
                this.propertyRawValueVariableName = this.parent.propertyRawValueVariableName;
            }
            if (this.propertyRawValueVariableName == null) {
                this.propertyRawValueVariableName = "rawValue";
            }
        }
        this.propertyErrorValueVariableName = this.asString(params.get("propertyErrorValueVariableName"));
        if (this.propertyErrorValueVariableName == null) {
            if (this.parent != null) {
                this.propertyErrorValueVariableName = this.parent.propertyErrorValueVariableName;
            }
            if (this.propertyErrorValueVariableName == null) {
                this.propertyErrorValueVariableName = "errorValue";
            }
        }
        this.errorsVariableName = this.asString(params.get("errorsVariableName"));
        if (this.errorsVariableName == null) {
            if (this.parent != null) {
                this.errorsVariableName = this.parent.errorsVariableName;
            }
            if (this.errorsVariableName == null) {
                this.errorsVariableName = "errors";
            }
        }
    }
}

