/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.iplass.mtp.web.actionmapping.definition.result.ContentDispositionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentDispositionPolicy {
    private static Logger logger = LoggerFactory.getLogger(ContentDispositionPolicy.class);
    private static String CONTENT_DISPOSITION_FILENAME_FORMAT = "filename*=%s''%s";
    private static String CONTENT_DISPOSITION_BOTH_FILENAME_FORMAT = "filename=\"%s\"; filename*=%s''%s";
    private String userAgentKey;
    private String defaultContentDispositionTypeName;
    private String contentDispositionTypeName;
    private String unescapeCharacter;
    private boolean useBothFilenameAttributes;

    public String getUserAgentKey() {
        return this.userAgentKey;
    }

    public void setUserAgentKey(String userAgentKey) {
        this.userAgentKey = userAgentKey;
    }

    public String getDefaultContentDispositionTypeName() {
        return this.defaultContentDispositionTypeName;
    }

    public void setDefaultContentDispositionTypeName(String defaultContentDispositionTypeName) {
        this.defaultContentDispositionTypeName = defaultContentDispositionTypeName;
    }

    public String getContentDispositionTypeName() {
        return this.contentDispositionTypeName;
    }

    public void setContentDispositionTypeName(String contentDispositionTypeName) {
        this.contentDispositionTypeName = contentDispositionTypeName;
    }

    public String getUnescapeCharacter() {
        return this.unescapeCharacter;
    }

    public void setUnescapeCharacter(String unescapeCharacter) {
        this.unescapeCharacter = unescapeCharacter;
    }

    public boolean isUseBothFilenameAttributes() {
        return this.useBothFilenameAttributes;
    }

    public void setUseBothFilenameAttributes(boolean useBothFilenameAttributes) {
        this.useBothFilenameAttributes = useBothFilenameAttributes;
    }

    public boolean isDefault() {
        return "*".equals(this.userAgentKey);
    }

    public boolean match(String userAgent, ContentDispositionType type) {
        return this.matchAgent(userAgent) && this.matchType(type);
    }

    public String getContentDisposition(ContentDispositionType type, String fileName) throws IOException {
        StringBuilder ret = new StringBuilder();
        if (type == null) {
            type = this.getDefaultContentDispositionType();
        }
        if (type != null) {
            ret.append(type.getTypeString());
        }
        ret.append(this.getFileNameString(fileName));
        logger.debug("{} 's content disposition ={}", (Object)fileName, (Object)ret.toString());
        return ret.toString();
    }

    private boolean matchAgent(String userAgent) {
        return userAgent.indexOf(this.userAgentKey) != -1;
    }

    private boolean matchType(ContentDispositionType type) {
        ContentDispositionType target = type;
        if (type == null) {
            target = this.getDefaultContentDispositionType();
        }
        return target == null || "*".equals(this.contentDispositionTypeName) || type == ContentDispositionType.valueOf(this.contentDispositionTypeName);
    }

    private ContentDispositionType getDefaultContentDispositionType() {
        if (this.defaultContentDispositionTypeName != null) {
            return ContentDispositionType.valueOf(this.defaultContentDispositionTypeName);
        }
        return null;
    }

    private String getFileNameString(String fileName) throws IOException {
        byte[] source = fileName.getBytes(StandardCharsets.UTF_8.name());
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(source.length);){
            for (byte b : source) {
                if (b < 0) {
                    b = (byte)(b + 256);
                }
                if (this.isUnescape(b)) {
                    bos.write(b);
                    continue;
                }
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
            }
            String escapeName = new String(bos.toByteArray(), "US-ASCII");
            String string = this.isUseBothFilenameAttributes() ? String.format(CONTENT_DISPOSITION_BOTH_FILENAME_FORMAT, fileName, StandardCharsets.UTF_8.name(), escapeName) : String.format(CONTENT_DISPOSITION_FILENAME_FORMAT, StandardCharsets.UTF_8.name(), escapeName);
            return string;
        }
    }

    private boolean isUnescape(int ch) {
        if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90) {
            return true;
        }
        if (ch >= 48 && ch <= 57) {
            return true;
        }
        if (this.unescapeCharacter != null) {
            return this.unescapeCharacter.indexOf(ch) >= 0;
        }
        return false;
    }
}

