/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.jwt;

public enum EllipticCurveSpec {
    P_256("P-256", 32),
    P_384("P-384", 48),
    P_521("P-521", 66);

    private final String curveName;
    private final int octetStringLength;

    private EllipticCurveSpec(String curveName, int octetStringLength) {
        this.curveName = curveName;
        this.octetStringLength = octetStringLength;
    }

    public String getCurveName() {
        return this.curveName;
    }

    public int getOctetStringLength() {
        return this.octetStringLength;
    }

    static EllipticCurveSpec preferredSpec(int keyLength) {
        if (keyLength >= 512) {
            return P_521;
        }
        if (keyLength >= 384) {
            return P_384;
        }
        return P_256;
    }
}

