/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.token.web;

import javax.servlet.http.HttpServletRequest;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.token.SimpleAuthTokenCredential;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginHandler;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginInstruction;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.authenticate.token.web.AuthorizationRequiredException;
import org.iplass.mtp.impl.session.Session;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.impl.webapi.rest.RestRequestContext;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webapi.definition.MethodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerTokenAutoLoginHandler
implements AutoLoginHandler {
    private static Logger logger = LoggerFactory.getLogger(BearerTokenAutoLoginHandler.class);
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String AUTH_SCHEME_BEARER = "Bearer";
    public static final String PARAM_ACCESS_TOKEN = "access_token";
    private static final String SESSION_ATTRIBUTE_BEARER_TOKEN = "mtp.auth.token.bearer.encodedToken";
    private SessionService sessionService = (SessionService)ServiceRegistry.getRegistry().getService(SessionService.class);
    private AuthTokenHandler authTokenHandler;
    private boolean rejectAmbiguousRequest;
    private boolean bearerTokenHeaderOnly;
    private String authTokenType;

    public boolean isBearerTokenHeaderOnly() {
        return this.bearerTokenHeaderOnly;
    }

    public void setBearerTokenHeaderOnly(boolean bearerTokenHeaderOnly) {
        this.bearerTokenHeaderOnly = bearerTokenHeaderOnly;
    }

    public String getAuthTokenType() {
        return this.authTokenType;
    }

    public void setAuthTokenType(String authTokenType) {
        this.authTokenType = authTokenType;
        this.authTokenHandler = ((AuthTokenService)ServiceRegistry.getRegistry().getService(AuthTokenService.class)).getHandler(authTokenType);
    }

    public boolean isRejectAmbiguousRequest() {
        return this.rejectAmbiguousRequest;
    }

    public void setRejectAmbiguousRequest(boolean rejectAmbiguousRequest) {
        this.rejectAmbiguousRequest = rejectAmbiguousRequest;
    }

    public void setAuthTokenHandler(AuthTokenHandler authTokenHandler) {
        this.authTokenHandler = authTokenHandler;
    }

    private boolean isForm(HttpServletRequest sr, RestRequestContext rrc) {
        if (this.bearerTokenHeaderOnly) {
            return false;
        }
        if (!"application/x-www-form-urlencoded".equals(sr.getContentType())) {
            return false;
        }
        return rrc.methodType() != MethodType.GET;
    }

    private String tokenFromRequest(RequestContext req) {
        String token = null;
        HttpServletRequest sr = (HttpServletRequest)req.getAttribute("servletRequest");
        String authHeaderValue = sr.getHeader(HEADER_AUTHORIZATION);
        if (authHeaderValue != null && authHeaderValue.regionMatches(true, 0, "Bearer ", 0, AUTH_SCHEME_BEARER.length() + 1)) {
            token = authHeaderValue.substring(AUTH_SCHEME_BEARER.length() + 1).trim();
            logger.debug("handle bearer token from HTTP header");
        } else if (this.isForm(sr, (RestRequestContext)req) && (token = req.getParam(PARAM_ACCESS_TOKEN)) != null) {
            logger.debug("handle bearer token from body(form parameter)");
        }
        if (token != null && token.length() > 0) {
            return token;
        }
        return null;
    }

    public AutoLoginInstruction handle(RequestContext req, boolean isLogined, UserContext user) {
        if (isLogined) {
            if (!(req instanceof RestRequestContext)) {
                return AutoLoginInstruction.ERROR;
            }
            RestRequestContext restReq = (RestRequestContext)req;
            if (!restReq.supportBearerToken()) {
                return AutoLoginInstruction.ERROR;
            }
            String tokenStr = this.tokenFromRequest(req);
            if (tokenStr == null) {
                return AutoLoginInstruction.THROUGH;
            }
            if (this.rejectAmbiguousRequest) {
                String tokenFromSess = null;
                Session s = this.sessionService.getSession(false);
                if (s != null) {
                    tokenFromSess = (String)s.getAttribute(SESSION_ATTRIBUTE_BEARER_TOKEN);
                }
                if (!tokenStr.equals(tokenFromSess)) {
                    throw new AuthorizationRequiredException(AUTH_SCHEME_BEARER, null, "invalid_request", "another login session is avaliable");
                }
            } else {
                AuthToken token = new AuthToken(tokenStr);
                logger.warn("login session is avaliable, but another bearer token is specified. currentUser:" + user.getAccount().getUnmodifiableUniqueKey() + ", token:" + token.getType() + "." + token.getSeries() + "...");
            }
            return AutoLoginInstruction.THROUGH;
        }
        if (!(req instanceof RestRequestContext)) {
            return AutoLoginInstruction.THROUGH;
        }
        RestRequestContext restReq = (RestRequestContext)req;
        if (!restReq.supportBearerToken()) {
            return AutoLoginInstruction.THROUGH;
        }
        String tokenStr = this.tokenFromRequest(req);
        if (tokenStr == null) {
            return AutoLoginInstruction.THROUGH;
        }
        AuthToken token = new AuthToken(tokenStr);
        if (!this.authTokenHandler.getType().equals(token.getType())) {
            return AutoLoginInstruction.THROUGH;
        }
        Credential cre = this.authTokenHandler.toCredential(token);
        return new AutoLoginInstruction(cre);
    }

    public void handleSuccess(AutoLoginInstruction ali, RequestContext req, UserContext user) {
        Session s;
        if (!this.sessionService.isSessionStateless() && (s = this.sessionService.getSession(false)) != null) {
            s.setAttribute(SESSION_ATTRIBUTE_BEARER_TOKEN, (Object)((SimpleAuthTokenCredential)ali.getCredential()).getToken());
        }
    }

    public Exception handleException(AutoLoginInstruction ali, ApplicationException e, RequestContext req, boolean isLogined, UserContext user) {
        throw new AuthorizationRequiredException(AUTH_SCHEME_BEARER, null, "invalid_token", "See server log for details");
    }
}

