/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.web.template.report;

import java.io.IOException;
import java.util.List;
import org.jxls.area.Area;
import org.jxls.area.CommandData;
import org.jxls.builder.xls.XlsCommentAreaBuilder;
import org.jxls.command.GridCommand;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.formula.FormulaProcessor;
import org.jxls.formula.StandardFormulaProcessor;
import org.jxls.transform.Transformer;

public interface JxlsReportOutputLogic {
    public void reportWrite(Transformer var1, Context var2);

    default public void processTemplateAtCell(Transformer transformer, Context context, String targetCell) throws IOException {
        XlsCommentAreaBuilder areaBuilder = new XlsCommentAreaBuilder();
        areaBuilder.setTransformer(transformer);
        List xlsAreaList = areaBuilder.build();
        if (xlsAreaList.isEmpty()) {
            throw new IllegalStateException("No XlsArea were detected for this processing");
        }
        Area firstArea = (Area)xlsAreaList.get(0);
        CellRef targetCellRef = new CellRef(targetCell);
        firstArea.applyAt(targetCellRef, context);
        firstArea.setFormulaProcessor((FormulaProcessor)new StandardFormulaProcessor());
        firstArea.processFormulas();
        String sourceSheetName = firstArea.getStartCellRef().getSheetName();
        if (!sourceSheetName.equalsIgnoreCase(targetCellRef.getSheetName())) {
            transformer.deleteSheet(sourceSheetName);
        }
        transformer.write();
    }

    default public void processGridTemplate(Transformer transformer, Context context, String objectProps) throws IOException {
        XlsCommentAreaBuilder areaBuilder = new XlsCommentAreaBuilder();
        areaBuilder.setTransformer(transformer);
        List xlsAreaList = areaBuilder.build();
        for (Area xlsArea : xlsAreaList) {
            GridCommand gridCommand = (GridCommand)((CommandData)xlsArea.getCommandDataList().get(0)).getCommand();
            gridCommand.setProps(objectProps);
            xlsArea.setFormulaProcessor((FormulaProcessor)new StandardFormulaProcessor());
            xlsArea.applyAt(new CellRef(xlsArea.getStartCellRef().getCellName()), context);
            xlsArea.processFormulas();
        }
        transformer.write();
    }

    default public void processGridTemplateAtCell(Transformer transformer, Context context, String objectProps, String targetCell) throws IOException {
        XlsCommentAreaBuilder areaBuilder = new XlsCommentAreaBuilder();
        areaBuilder.setTransformer(transformer);
        List xlsAreaList = areaBuilder.build();
        Area firstArea = (Area)xlsAreaList.get(0);
        CellRef targetCellRef = new CellRef(targetCell);
        GridCommand gridCommand = (GridCommand)((CommandData)firstArea.getCommandDataList().get(0)).getCommand();
        gridCommand.setProps(objectProps);
        firstArea.applyAt(targetCellRef, context);
        firstArea.setFormulaProcessor((FormulaProcessor)new StandardFormulaProcessor());
        firstArea.processFormulas();
        String sourceSheetName = firstArea.getStartCellRef().getSheetName();
        if (!sourceSheetName.equalsIgnoreCase(targetCellRef.getSheetName())) {
            transformer.deleteSheet(sourceSheetName);
        }
        transformer.write();
    }
}

