/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.rest;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.impl.webapi.WebApiResponse;
import org.iplass.mtp.impl.webapi.WebApiService;
import org.iplass.mtp.impl.webapi.rest.WrappedRestException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.webapi.WebApiRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtpExceptionMapper
implements ExceptionMapper<Throwable> {
    private static Logger logger = LoggerFactory.getLogger(MtpExceptionMapper.class);
    private static Logger fatalLogger = LoggerFactory.getLogger((String)"mtp.fatal");
    public static final String STATUS_FAILURE = "FAILURE";
    private WebApiService waservice = (WebApiService)ServiceRegistry.getRegistry().getService(WebApiService.class);

    public Response toResponse(Throwable exception) {
        if (exception instanceof WebApplicationException) {
            if (logger.isDebugEnabled()) {
                logger.debug("WebApplicationException on web api call:" + exception, exception);
            }
            return ((WebApplicationException)exception).getResponse();
        }
        if (exception instanceof WrappedRestException) {
            Throwable cause;
            WrappedRestException exp = (WrappedRestException)exception;
            WebApiResponse res = exp.getResponse();
            if (res == null) {
                res = new WebApiResponse();
                cause = exp.getCause();
            } else {
                cause = res.getException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("runtime excepion on web api call:" + cause, cause);
            }
            res.setException(this.treatException(cause));
            if (res.getStatus() == null) {
                res.setStatus(STATUS_FAILURE);
            }
            return Response.status((Response.Status)this.mapStatus(cause)).entity((Object)res).build();
        }
        if (exception instanceof Error) {
            fatalLogger.error(exception.toString(), exception);
        }
        logger.error("unhandle excepion on web api call:" + exception, exception);
        return Response.status((Response.Status)this.mapStatus(exception)).build();
    }

    private Throwable treatException(Throwable e) {
        if (e instanceof ApplicationException) {
            return e;
        }
        return new WebApiRuntimeException("System error occurred. See server log detail.");
    }

    protected Response.Status mapStatus(Throwable e) {
        int statusCode = this.waservice.mapStatus(e);
        return Response.Status.fromStatusCode((int)statusCode);
    }
}

