/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi;

import java.io.Serializable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.webapi.WebApiVariableParameterValueMap;
import org.iplass.mtp.webapi.definition.WebApiParamMapDefinition;

public class MetaWebApiParamMap
implements MetaData {
    private static final long serialVersionUID = -3370788488772223300L;
    private static final String SCRIPT_PREFIX = "MetaWebApiParamMap_condition";
    private String name;
    private String mapFrom;
    private String condition;

    public MetaWebApiParamMap() {
    }

    public MetaWebApiParamMap(String name, String mapFrom) {
        this.name = name;
        this.mapFrom = mapFrom;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMapFrom() {
        return this.mapFrom;
    }

    public void setMapFrom(String mapFrom) {
        this.mapFrom = mapFrom;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void applyConfig(WebApiParamMapDefinition definition) {
        this.name = definition.getName();
        this.mapFrom = definition.getMapFrom();
        this.condition = definition.getCondition();
    }

    public WebApiParamMapDefinition currentConfig() {
        WebApiParamMapDefinition definition = new WebApiParamMapDefinition();
        definition.setName(this.name);
        definition.setMapFrom(this.mapFrom);
        definition.setCondition(this.condition);
        return definition;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }

    public WebApiParamMapRuntime createRuntime() {
        return new WebApiParamMapRuntime();
    }

    private static enum MapType {
        PARAM_ALIAS,
        FULL_PATH,
        SUB_PATH,
        PATHS;

    }

    public class WebApiParamMapRuntime {
        private Script conditionScript;
        private MapType type;
        private int depth;

        WebApiParamMapRuntime() {
            if (MetaWebApiParamMap.this.condition != null && !MetaWebApiParamMap.this.condition.isEmpty()) {
                TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                ScriptEngine ss = tc.getScriptEngine();
                KeyGenerator keyGen = new KeyGenerator();
                this.conditionScript = ss.createScript(MetaWebApiParamMap.this.condition, "MetaWebApiParamMap_condition_" + keyGen.generateId());
            }
            if (MetaWebApiParamMap.this.name == null) {
                throw new MetaDataRuntimeException("ParamMap's name must be specified.");
            }
            if (MetaWebApiParamMap.this.mapFrom == null) {
                throw new MetaDataRuntimeException("ParamMap's mapFrom must be specified.");
            }
            if (MetaWebApiParamMap.this.mapFrom.startsWith("{")) {
                this.type = MapType.FULL_PATH;
                this.depth = Integer.parseInt(MetaWebApiParamMap.this.mapFrom.substring(1, MetaWebApiParamMap.this.mapFrom.length() - 1).trim());
            } else if (MetaWebApiParamMap.this.mapFrom.startsWith("${")) {
                String val = MetaWebApiParamMap.this.mapFrom.substring(2, MetaWebApiParamMap.this.mapFrom.length() - 1).trim();
                if (val.startsWith("subPath[")) {
                    this.type = MapType.SUB_PATH;
                    this.depth = Integer.parseInt(val.substring(8, val.length() - 1).trim());
                } else if (val.startsWith("fullPath[")) {
                    this.type = MapType.FULL_PATH;
                    this.depth = Integer.parseInt(val.substring(9, val.length() - 1).trim());
                } else if ("paths".equals(val)) {
                    this.type = MapType.PATHS;
                } else {
                    this.type = MapType.SUB_PATH;
                    this.depth = Integer.parseInt(val.trim());
                }
            } else {
                this.type = MapType.PARAM_ALIAS;
            }
        }

        public MetaWebApiParamMap getMetaData() {
            return MetaWebApiParamMap.this;
        }

        public boolean isTarget(WebApiVariableParameterValueMap paramValueMap) {
            if (this.conditionScript == null) {
                return true;
            }
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            ScriptEngine ss = tc.getScriptEngine();
            ScriptContext sc = ss.newScriptContext();
            sc.setAttribute("subPath", (Object)paramValueMap.getSubPaths());
            sc.setAttribute("fullPath", (Object)paramValueMap.getFullPaths());
            sc.setAttribute("paramMap", paramValueMap.getWrapped().getParamMap());
            Boolean ret = (Boolean)this.conditionScript.eval(sc);
            return ret != null && ret != false;
        }

        public Object getParam(WebApiVariableParameterValueMap paramValueMap) {
            switch (this.type) {
                case PARAM_ALIAS: {
                    return paramValueMap.getWrapped().getParam(MetaWebApiParamMap.this.mapFrom);
                }
                case FULL_PATH: {
                    String[] fullPaths = paramValueMap.getFullPaths();
                    if (fullPaths.length > this.depth) {
                        return fullPaths[this.depth];
                    }
                    return null;
                }
                case SUB_PATH: {
                    String[] subPaths = paramValueMap.getSubPaths();
                    if (subPaths.length > this.depth) {
                        return subPaths[this.depth];
                    }
                    return null;
                }
                case PATHS: {
                    return paramValueMap.getSubPath();
                }
            }
            return null;
        }

        public Object[] getParams(WebApiVariableParameterValueMap paramValueMap) {
            switch (this.type) {
                case PARAM_ALIAS: {
                    return paramValueMap.getWrapped().getParams(MetaWebApiParamMap.this.mapFrom);
                }
                case FULL_PATH: {
                    String[] fullPaths = paramValueMap.getFullPaths();
                    if (fullPaths.length > this.depth) {
                        return new String[]{fullPaths[this.depth]};
                    }
                    return null;
                }
                case SUB_PATH: {
                    String[] subPaths = paramValueMap.getSubPaths();
                    if (subPaths.length > this.depth) {
                        return new String[]{subPaths[this.depth]};
                    }
                    return null;
                }
                case PATHS: {
                    String paths = paramValueMap.getSubPath();
                    if (paths != null) {
                        return new String[]{paths};
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

