/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template.report;

import java.io.IOException;
import java.util.List;
import org.codehaus.groovy.runtime.MethodClosure;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.web.template.report.MetaJxlsReportOutputLogic;
import org.iplass.mtp.impl.web.template.report.MetaJxlsReportType;
import org.iplass.mtp.impl.web.template.report.MetaReportType;
import org.iplass.mtp.web.template.report.definition.GroovyReportOutputLogicDefinition;
import org.iplass.mtp.web.template.report.definition.ReportOutputLogicDefinition;
import org.jxls.area.Area;
import org.jxls.area.CommandData;
import org.jxls.builder.xls.XlsCommentAreaBuilder;
import org.jxls.command.GridCommand;
import org.jxls.common.CellRef;
import org.jxls.common.Context;
import org.jxls.formula.FormulaProcessor;
import org.jxls.formula.StandardFormulaProcessor;
import org.jxls.transform.Transformer;

public class MetaGroovyJxlsReportOutputLogic
extends MetaJxlsReportOutputLogic {
    private static final long serialVersionUID = -2510252715491801950L;
    private String script;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public MetaGroovyJxlsReportOutputLogic copy() {
        MetaGroovyJxlsReportOutputLogic copy = new MetaGroovyJxlsReportOutputLogic();
        copy.script = this.script;
        return copy;
    }

    @Override
    public void applyConfig(ReportOutputLogicDefinition def) {
        GroovyReportOutputLogicDefinition d = (GroovyReportOutputLogicDefinition)def;
        this.script = d.getScript();
    }

    @Override
    public ReportOutputLogicDefinition currentConfig() {
        GroovyReportOutputLogicDefinition d = new GroovyReportOutputLogicDefinition();
        this.fillTo(d);
        d.setScript(this.script);
        return d;
    }

    @Override
    public MetaJxlsReportOutputLogic.JxlsReportOutputLogicRuntime createRuntime(MetaReportType reportType) {
        return new GroovyJxlsReportOutputLogicRuntime(reportType);
    }

    public class GroovyJxlsReportOutputLogicRuntime
    extends MetaJxlsReportOutputLogic.JxlsReportOutputLogicRuntime {
        private static final String SCRIPT_PREFIX = "GroovyJxlsReportOutputLogicRuntime_script";
        private Script compiledScript;
        private ScriptEngine scriptEngine;

        public GroovyJxlsReportOutputLogicRuntime(MetaReportType reportType) {
            super(MetaGroovyJxlsReportOutputLogic.this);
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptEngine = tc.getScriptEngine();
            if (MetaGroovyJxlsReportOutputLogic.this.script != null) {
                String scriptName = null;
                MetaJxlsReportType jxlsTemp = (MetaJxlsReportType)reportType;
                if (jxlsTemp.getReportOutputLogic() != null) {
                    scriptName = "GroovyJxlsReportOutputLogicRuntime_script_" + reportType.getOutputFileType() + "_" + GroovyTemplateCompiler.randomName();
                }
                this.compiledScript = this.scriptEngine.createScript(MetaGroovyJxlsReportOutputLogic.this.script, scriptName);
            }
        }

        private Object callScript(Transformer transformer, Context context) {
            ScriptContext sc = this.scriptEngine.newScriptContext();
            sc.setAttribute("transformer", (Object)transformer);
            sc.setAttribute("context", (Object)context);
            sc.setAttribute("processTemplateAtCell", (Object)new MethodClosure((Object)this, "processTemplateAtCell"));
            sc.setAttribute("processGridTemplate", (Object)new MethodClosure((Object)this, "processGridTemplate"));
            sc.setAttribute("processGridTemplateAtCell", (Object)new MethodClosure((Object)this, "processGridTemplateAtCell"));
            return this.compiledScript.eval(sc);
        }

        @Override
        public void outputReport(Transformer transformer, Context context) {
            this.callScript(transformer, context);
        }

        public void processTemplateAtCell(Transformer transformer, Context context, String targetCell) throws IOException {
            XlsCommentAreaBuilder areaBuilder = new XlsCommentAreaBuilder();
            areaBuilder.setTransformer(transformer);
            List xlsAreaList = areaBuilder.build();
            if (xlsAreaList.isEmpty()) {
                throw new IllegalStateException("No XlsArea were detected for this processing");
            }
            Area firstArea = (Area)xlsAreaList.get(0);
            CellRef targetCellRef = new CellRef(targetCell);
            firstArea.applyAt(targetCellRef, context);
            firstArea.setFormulaProcessor((FormulaProcessor)new StandardFormulaProcessor());
            firstArea.processFormulas();
            String sourceSheetName = firstArea.getStartCellRef().getSheetName();
            if (!sourceSheetName.equalsIgnoreCase(targetCellRef.getSheetName())) {
                transformer.deleteSheet(sourceSheetName);
            }
            transformer.write();
        }

        public void processGridTemplate(Transformer transformer, Context context, String objectProps) throws IOException {
            XlsCommentAreaBuilder areaBuilder = new XlsCommentAreaBuilder();
            areaBuilder.setTransformer(transformer);
            List xlsAreaList = areaBuilder.build();
            for (Area xlsArea : xlsAreaList) {
                GridCommand gridCommand = (GridCommand)((CommandData)xlsArea.getCommandDataList().get(0)).getCommand();
                gridCommand.setProps(objectProps);
                xlsArea.setFormulaProcessor((FormulaProcessor)new StandardFormulaProcessor());
                xlsArea.applyAt(new CellRef(xlsArea.getStartCellRef().getCellName()), context);
                xlsArea.processFormulas();
            }
            transformer.write();
        }

        public void processGridTemplateAtCell(Transformer transformer, Context context, String objectProps, String targetCell) throws IOException {
            XlsCommentAreaBuilder areaBuilder = new XlsCommentAreaBuilder();
            areaBuilder.setTransformer(transformer);
            List xlsAreaList = areaBuilder.build();
            Area firstArea = (Area)xlsAreaList.get(0);
            CellRef targetCellRef = new CellRef(targetCell);
            GridCommand gridCommand = (GridCommand)((CommandData)firstArea.getCommandDataList().get(0)).getCommand();
            gridCommand.setProps(objectProps);
            firstArea.applyAt(targetCellRef, context);
            firstArea.setFormulaProcessor((FormulaProcessor)new StandardFormulaProcessor());
            firstArea.processFormulas();
            String sourceSheetName = firstArea.getStartCellRef().getSheetName();
            if (!sourceSheetName.equalsIgnoreCase(targetCellRef.getSheetName())) {
                transformer.deleteSheet(sourceSheetName);
            }
            transformer.write();
        }
    }
}

