/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template.groovy;

import groovy.lang.Binding;
import groovy.lang.MissingPropertyException;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.command.beanmapper.MappingError;
import org.iplass.mtp.command.beanmapper.MappingException;
import org.iplass.mtp.command.beanmapper.MappingResult;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.impl.web.template.groovy.BindContext;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorsContext {
    private static Logger log = LoggerFactory.getLogger(ErrorsContext.class);
    String errorsVariableName;
    String delimiter;
    String header;
    String footer;
    Boolean htmlEscape;
    BindContext bindContext;
    Object errors;
    Binding binding;
    boolean writeFirst;

    ErrorsContext(Map<String, Object> params, BindContext bindContext) {
        this.bindContext = bindContext;
        this.initParam(params);
        this.errors = params.get("errors");
        if (this.errors == null) {
            if (bindContext != null) {
                MappingResult me;
                if (bindContext.getBinding() != null) {
                    try {
                        this.errors = bindContext.getBinding().getVariable(this.errorsVariableName);
                    }
                    catch (MissingPropertyException missingPropertyException) {
                        // empty catch block
                    }
                }
                if (this.errors == null && bindContext.setBean && (me = bindContext.mappingResult) != null && me.hasError()) {
                    this.errors = me.getErrors();
                }
            } else {
                WebRequestStack webStack = WebRequestStack.getCurrent();
                if (webStack != null) {
                    this.errors = webStack.getRequestContext().getAttribute("mtp.web.exception");
                }
            }
        }
        if (this.errors != null) {
            this.setVariable(this.errorsVariableName, this.errors);
        } else {
            this.setVariable(this.errorsVariableName, null);
        }
    }

    private void initParam(Map<String, Object> params) {
        this.errorsVariableName = this.asString(params.get("errorsVariableName"));
        if (this.errorsVariableName == null) {
            this.errorsVariableName = this.bindContext != null ? this.bindContext.errorsVariableName : "errors";
        }
        this.htmlEscape = (Boolean)params.get("htmlEscape");
        if (this.htmlEscape == null) {
            if (this.bindContext != null) {
                this.htmlEscape = this.bindContext.htmlEscape;
            }
            if (this.htmlEscape == null) {
                this.htmlEscape = Boolean.TRUE;
            }
        }
        this.delimiter = this.asString(params.get("delimiter"));
        if (this.delimiter == null) {
            this.delimiter = "<br>";
        }
        this.header = this.asString(params.get("header"));
        if (this.header == null) {
            this.header = "<span class=\"error\">";
        }
        this.footer = this.asString(params.get("footer"));
        if (this.footer == null) {
            this.footer = "</span>";
        }
    }

    private String asString(Object val) {
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    private void setVariable(String name, Object value) {
        if (this.binding == null) {
            this.binding = new Binding();
        }
        this.binding.setVariable(name, value);
    }

    public Binding getBinding() {
        return this.binding;
    }

    private void writeError(Object errors, Writer out) throws IOException {
        if (errors instanceof String) {
            this.writeMessage((String)errors, out);
        } else if (errors instanceof List) {
            for (Object e : (List)errors) {
                this.writeError(e, out);
            }
        } else if (errors instanceof Object[]) {
            Object[] array = (Object[])errors;
            for (int i = 0; i < array.length; ++i) {
                this.writeError(array[i], out);
            }
        } else if (errors instanceof MappingError) {
            for (String m : ((MappingError)errors).getErrorMessages()) {
                this.writeError(m, out);
            }
        } else if (errors instanceof MappingResult) {
            for (MappingError me : ((MappingResult)errors).getErrors()) {
                this.writeError(me, out);
            }
        } else if (errors instanceof MappingException) {
            this.writeError(((MappingException)errors).getResult(), out);
        } else if (errors instanceof ApplicationException) {
            this.writeMessage(((ApplicationException)((Object)errors)).getMessage(), out);
        } else if (errors instanceof Throwable) {
            if (log.isDebugEnabled()) {
                log.debug("System Exception: " + errors + " occoured. Message details are not output.");
            }
            if (this.writeFirst) {
                out.write(this.delimiter);
            } else {
                this.writeFirst = true;
            }
            this.writeMessage(ErrorsContext.resourceString("error.Error.retryMsg", new Object[0]), out);
        } else if (errors != null) {
            this.writeMessage(errors.toString(), out);
        }
    }

    private void writeMessage(String msg, Writer out) throws IOException {
        if (this.writeFirst) {
            out.write(this.delimiter);
        } else {
            this.writeFirst = true;
        }
        if (this.htmlEscape.booleanValue()) {
            out.write(StringUtil.escapeHtml((String)msg));
        } else {
            out.write(msg);
        }
    }

    public void write(Writer w) {
        try {
            w.write(this.header);
            this.writeError(this.errors, w);
            w.write(this.footer);
        }
        catch (IOException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public boolean hasError() {
        return this.errors != null;
    }

    private static String resourceString(String key, Object ... arguments) {
        return WebResourceBundleUtil.resourceString(key, arguments);
    }
}

