/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.command;

import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.webapi.WebApi;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.command.CommandUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.iplass.mtp.webapi.definition.StateType;

@WebApi(name="oauth/revoke", accepts={RequestType.REST_FORM}, methods={MethodType.POST}, checkXRequestedWithHeader=false, privilaged=true, state=StateType.STATELESS, responseType="application/json")
@CommandClass(name="mtp/oauth/RevokeCommand", displayName="OAuth2.0 Token Revocation Endpoint")
public class RevokeCommand
implements Command {
    static final String PARAM_TOKEN = "token";
    static final String PARAM_TOKEN_TYPE_HINT = "token_type_hint";
    static final String STAT_SUCCESS = "SUCCESS";

    public String execute(RequestContext request) {
        MetaOAuthClient.OAuthClientRuntime clientRuntime = CommandUtil.validateClient(request, true);
        String token = request.getParam(PARAM_TOKEN);
        String tokenTypeHint = StringUtil.stripToNull((String)request.getParam(PARAM_TOKEN_TYPE_HINT));
        clientRuntime.getAuthorizationServer().revoke(token, tokenTypeHint, clientRuntime);
        return STAT_SUCCESS;
    }
}

