/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.auth.oauth.definition.ClientPolicyDefinition;
import org.iplass.mtp.auth.oauth.definition.ClientType;
import org.iplass.mtp.impl.auth.oauth.MetaConsentType;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaScope;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaClientPolicy
implements MetaData {
    private static final long serialVersionUID = 3667544863207206056L;
    private ClientType clientType;
    private long accessTokenLifetimeSeconds;
    private boolean supportRefreshToken;
    private long refreshTokenLifetimeSeconds;
    private MetaConsentType consentType;
    private List<String> scopes;
    private boolean supportOpenIDConnect;

    public boolean isSupportOpenIDConnect() {
        return this.supportOpenIDConnect;
    }

    public void setSupportOpenIDConnect(boolean supportOpenIDConnect) {
        this.supportOpenIDConnect = supportOpenIDConnect;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public void setClientType(ClientType clientType) {
        this.clientType = clientType;
    }

    public long getAccessTokenLifetimeSeconds() {
        return this.accessTokenLifetimeSeconds;
    }

    public void setAccessTokenLifetimeSeconds(long accessTokenLifetimeSeconds) {
        this.accessTokenLifetimeSeconds = accessTokenLifetimeSeconds;
    }

    public boolean isSupportRefreshToken() {
        return this.supportRefreshToken;
    }

    public void setSupportRefreshToken(boolean supportRefreshToken) {
        this.supportRefreshToken = supportRefreshToken;
    }

    public long getRefreshTokenLifetimeSeconds() {
        return this.refreshTokenLifetimeSeconds;
    }

    public void setRefreshTokenLifetimeSeconds(long refreshTokenLifetimeSeconds) {
        this.refreshTokenLifetimeSeconds = refreshTokenLifetimeSeconds;
    }

    public MetaConsentType getConsentType() {
        return this.consentType;
    }

    public void setConsentType(MetaConsentType consentType) {
        this.consentType = consentType;
    }

    public MetaClientPolicy copy() {
        return (MetaClientPolicy)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public ClientPolicyRuntime createRuntime(MetaOAuthAuthorization metaOauth) {
        return new ClientPolicyRuntime(metaOauth);
    }

    public void applyConfig(ClientPolicyDefinition def) {
        this.clientType = def.getClientType();
        this.accessTokenLifetimeSeconds = def.getAccessTokenLifetimeSeconds();
        this.supportRefreshToken = def.isSupportRefreshToken();
        this.refreshTokenLifetimeSeconds = def.getRefreshTokenLifetimeSeconds();
        if (def.getConsentType() != null) {
            this.consentType = MetaConsentType.createInstance(def.getConsentType());
            this.consentType.applyConfig(def.getConsentType());
        } else {
            this.consentType = null;
        }
        this.scopes = def.getScopes() != null ? new ArrayList<String>(def.getScopes()) : null;
        this.supportOpenIDConnect = def.isSupportOpenIDConnect();
    }

    public ClientPolicyDefinition currentConfig() {
        ClientPolicyDefinition def = new ClientPolicyDefinition();
        def.setClientType(this.clientType);
        def.setAccessTokenLifetimeSeconds(this.accessTokenLifetimeSeconds);
        def.setSupportRefreshToken(this.supportRefreshToken);
        def.setRefreshTokenLifetimeSeconds(this.refreshTokenLifetimeSeconds);
        if (this.consentType != null) {
            def.setConsentType(this.consentType.currentConfig());
        }
        if (this.scopes != null) {
            def.setScopes(new ArrayList<String>(this.scopes));
        }
        def.setSupportOpenIDConnect(this.supportOpenIDConnect);
        return def;
    }

    public class ClientPolicyRuntime {
        private MetaConsentType.ConsentTypeRuntime consentTypeRuntime;
        private List<String> scopeList;

        private ClientPolicyRuntime(MetaOAuthAuthorization metaOauth) {
            if (MetaClientPolicy.this.consentType != null) {
                this.consentTypeRuntime = MetaClientPolicy.this.consentType.createRuntime(metaOauth.getId(), MetaClientPolicy.this.clientType);
            }
            this.scopeList = new ArrayList<String>();
            for (MetaScope ms : metaOauth.getScopes()) {
                if (MetaClientPolicy.this.getScopes() != null && !MetaClientPolicy.this.getScopes().contains(ms.getName())) continue;
                this.scopeList.add(ms.getName());
            }
            if (MetaClientPolicy.this.supportRefreshToken && !this.scopeList.contains("offline_access")) {
                this.scopeList.add("offline_access");
            }
            if (MetaClientPolicy.this.supportOpenIDConnect && !this.scopeList.contains("openid")) {
                this.scopeList.add("openid");
            }
        }

        public MetaClientPolicy getMetaData() {
            return MetaClientPolicy.this;
        }

        public MetaConsentType.ConsentTypeRuntime consentType() {
            return this.consentTypeRuntime;
        }

        public List<String> scopeList() {
            return this.scopeList;
        }

        public boolean isRequireRefreshToken(List<String> grantedScopes) {
            return MetaClientPolicy.this.supportRefreshToken && grantedScopes != null && grantedScopes.contains("offline_access");
        }

        public boolean isRequireIdToken(List<String> grantedScopes) {
            return MetaClientPolicy.this.supportOpenIDConnect && grantedScopes != null && grantedScopes.contains("openid");
        }
    }
}

