/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth;

import java.io.Serializable;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.oauth.definition.ClaimMappingDefinition;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaClaimMapping
implements MetaData {
    private static final long serialVersionUID = -3286338403698162013L;
    private String claimName;
    private String userPropertyName;
    private String customValueScript;

    public MetaClaimMapping() {
    }

    public MetaClaimMapping(String claimName, String userPropertyName) {
        this.claimName = claimName;
        this.userPropertyName = userPropertyName;
    }

    public String getClaimName() {
        return this.claimName;
    }

    public void setClaimName(String claimName) {
        this.claimName = claimName;
    }

    public String getUserPropertyName() {
        return this.userPropertyName;
    }

    public void setUserPropertyName(String userPropertyName) {
        this.userPropertyName = userPropertyName;
    }

    public String getCustomValueScript() {
        return this.customValueScript;
    }

    public void setCustomValueScript(String customValueScript) {
        this.customValueScript = customValueScript;
    }

    public MetaClaimMapping copy() {
        return (MetaClaimMapping)((Object)ObjectUtil.deepCopy((Serializable)((Object)this)));
    }

    public void applyConfig(ClaimMappingDefinition cmd) {
        this.claimName = cmd.getClaimName();
        this.userPropertyName = cmd.getUserPropertyName();
        this.customValueScript = cmd.getCustomValueScript();
    }

    public ClaimMappingDefinition currentConfig() {
        ClaimMappingDefinition def = new ClaimMappingDefinition();
        def.setClaimName(this.claimName);
        def.setUserPropertyName(this.userPropertyName);
        def.setCustomValueScript(this.customValueScript);
        return def;
    }

    public ClaimMappingRuntime createRuntime(String defName, String scopeName) {
        return new ClaimMappingRuntime(defName, scopeName);
    }

    public class ClaimMappingRuntime {
        private ScriptEngine se;
        private Script s;

        private ClaimMappingRuntime(String defName, String scopeName) {
            if (MetaClaimMapping.this.customValueScript != null) {
                TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                this.se = tc.getScriptEngine();
                this.s = this.se.createScript(MetaClaimMapping.this.customValueScript, "CustomValueScript_" + defName + "_" + scopeName + "_" + MetaClaimMapping.this.claimName);
            }
        }

        public Object value(User user) {
            if (MetaClaimMapping.this.userPropertyName != null) {
                return user.getValue(MetaClaimMapping.this.userPropertyName);
            }
            ScriptContext sc = this.se.newScriptContext();
            sc.setAttribute("user", (Object)user);
            return this.s.eval(sc);
        }

        public String name() {
            return MetaClaimMapping.this.claimName;
        }
    }
}

