/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.webapi;

import java.util.ArrayList;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.webapi.BuiltinWebApiAuthContext;
import org.iplass.mtp.impl.auth.authorize.builtin.webapi.WebApiPermissionEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebApiAuthContextCacheLogic
extends AuthorizationContextCacheLogic {
    private static final Logger logger = LoggerFactory.getLogger(WebApiAuthContextCacheLogic.class);
    public static final String WEB_API_PERMISSION_DEF_NAME = "mtp.auth.WebApiPermission";
    public static final String WEB_API_PATH = "targetWebApi";
    public static final String WEB_API_CONDITION = "conditionExpression";
    public static final String WEB_API_ROLE = "role";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    WebApiAuthContextCacheLogic(TenantAuthorizeContext authorizeContext) {
        super(authorizeContext);
    }

    protected BuiltinAuthorizationContext loadImpl(String key) {
        return (BuiltinAuthorizationContext)AuthContext.doPrivileged(() -> {
            Query q = new Query().select(new Object[]{"oid", WEB_API_CONDITION, "role.code"}).from(WEB_API_PERMISSION_DEF_NAME).where((Condition)new Equals(WEB_API_PATH, (Object)key));
            ArrayList entries = new ArrayList();
            this.em.search(q, dataModel -> {
                if (dataModel[2] != null) {
                    WebApiPermissionEntry e = new WebApiPermissionEntry((String)dataModel[2], (String)dataModel[0], (String)dataModel[1]);
                    entries.add(e);
                } else {
                    logger.warn("role code not defined. so ignore this entry:oid=" + dataModel[0]);
                }
                return true;
            });
            if (entries.size() == 0) {
                return null;
            }
            return new BuiltinWebApiAuthContext(key, entries.toArray(new WebApiPermissionEntry[entries.size()]), this.authorizeContext);
        });
    }
}

