/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.webapi;

import java.util.LinkedList;
import java.util.List;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.auth.UserBinding;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.role.RoleContext;
import org.iplass.mtp.impl.auth.authorize.builtin.webapi.WebApiPermissionEntry;
import org.iplass.mtp.impl.webapi.auth.WebApiAuthContext;
import org.iplass.mtp.webapi.permission.WebApiPermission;

class BuiltinWebApiAuthContext
extends BuiltinAuthorizationContext
implements WebApiAuthContext {
    private WebApiPermissionEntry[] permissionEntry;
    private TenantAuthorizeContext tenantAuthContext;
    private boolean hasParameterCondition;

    BuiltinWebApiAuthContext(String webApiName, WebApiPermissionEntry[] permissionEntry, TenantAuthorizeContext tenantAuthContext) {
        super(webApiName);
        this.permissionEntry = permissionEntry;
        this.tenantAuthContext = tenantAuthContext;
        if (permissionEntry != null) {
            for (WebApiPermissionEntry wpe : permissionEntry) {
                if (!wpe.hasParam()) continue;
                this.hasParameterCondition = true;
                break;
            }
        }
    }

    private List<WebApiPermissionEntry> listTarget(AuthContextHolder userAuthContext) {
        LinkedList<WebApiPermissionEntry> target = new LinkedList<WebApiPermissionEntry>();
        long currentPriority = 0L;
        for (int i = 0; i < this.permissionEntry.length; ++i) {
            if (!userAuthContext.userInRole(this.permissionEntry[i].getRole(), this.tenantAuthContext.getTenantContext().getTenantId())) continue;
            RoleContext role = this.tenantAuthContext.getRoleContext(this.permissionEntry[i].getRole());
            if (currentPriority < role.getPriority()) {
                currentPriority = role.getPriority();
                target.clear();
            }
            if (currentPriority != role.getPriority()) continue;
            target.add(this.permissionEntry[i]);
        }
        return target;
    }

    public boolean isPermit(Permission permission, AuthContextHolder user) {
        UserBinding userBinding = user.newUserBinding(this.tenantAuthContext);
        if (userBinding.isGrantAllPermissions()) {
            return true;
        }
        WebApiPermission wap = (WebApiPermission)permission;
        List<WebApiPermissionEntry> target = this.listTarget(user);
        for (WebApiPermissionEntry pe : target) {
            if (!pe.isPermit(user, wap.getWebApiName(), wap.getParameter(), this.tenantAuthContext)) continue;
            return true;
        }
        return false;
    }

    public boolean isResultCacheable(Permission permission) {
        return !this.hasParameterCondition;
    }
}

