/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.jee;

import java.security.Principal;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AccountManagementModule;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProviderBase;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginHandler;
import org.iplass.mtp.impl.auth.authenticate.AutoLoginInstruction;
import org.iplass.mtp.impl.auth.authenticate.DefaultUserEntityResolver;
import org.iplass.mtp.impl.auth.authenticate.jee.JeeContainerManagedAccountHandle;
import org.iplass.mtp.impl.auth.authenticate.jee.JeeContainerManagedCredential;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.spi.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JeeContainerManagedAuthenticationProvider
extends AuthenticationProviderBase
implements AutoLoginHandler {
    private static Logger logger = LoggerFactory.getLogger(JeeContainerManagedAuthenticationProvider.class);
    private String[] roleAsGroup;
    private boolean validateOnlyLogin;

    public boolean isValidateOnlyLogin() {
        return this.validateOnlyLogin;
    }

    public void setValidateOnlyLogin(boolean validateOnlyLogin) {
        this.validateOnlyLogin = validateOnlyLogin;
    }

    public String[] getRoleAsGroup() {
        return this.roleAsGroup;
    }

    public void setRoleAsGroup(String[] roleAsGroup) {
        this.roleAsGroup = roleAsGroup;
    }

    public void inited(AuthService service, Config config) {
        boolean userEntityResolverIsNull = this.getUserEntityResolver() == null;
        super.inited(service, config);
        if (userEntityResolverIsNull) {
            ((DefaultUserEntityResolver)this.getUserEntityResolver()).setUnmodifiableUniqueKeyProperty("accountId");
        }
    }

    public AccountHandle login(Credential credential) {
        if (!(credential instanceof JeeContainerManagedCredential)) {
            return null;
        }
        WebRequestStack reqStack = WebRequestStack.getCurrent();
        HttpServletRequest req = reqStack.getRequest();
        Principal up = req.getUserPrincipal();
        if (up == null) {
            return null;
        }
        if (!up.getName().equals(credential.getId())) {
            return null;
        }
        JeeContainerManagedAccountHandle ret = new JeeContainerManagedAccountHandle(credential.getId());
        if (this.roleAsGroup != null) {
            ArrayList<String> groups = new ArrayList<String>();
            for (String r : this.roleAsGroup) {
                if (!req.isUserInRole(r)) continue;
                groups.add(r);
            }
            if (groups.size() > 0) {
                ret.getAttributeMap().put("groupCode", groups.toArray(new String[groups.size()]));
            }
        }
        return ret;
    }

    public void logout(AccountHandle user) {
        if (user instanceof JeeContainerManagedAccountHandle) {
            WebRequestStack reqStack = WebRequestStack.getCurrent();
            HttpServletRequest req = reqStack.getRequest();
            try {
                req.logout();
            }
            catch (ServletException e) {
                logger.debug("logout fail.", (Throwable)e);
            }
        }
    }

    public AccountManagementModule getAccountManagementModule() {
        return NO_UPDATABLE_AMM;
    }

    public Class<? extends Credential> getCredentialType() {
        return JeeContainerManagedCredential.class;
    }

    protected Class<? extends AccountHandle> getAccountHandleClassForTrust() {
        return JeeContainerManagedAccountHandle.class;
    }

    public AutoLoginHandler getAutoLoginHandler() {
        return this;
    }

    public AutoLoginInstruction handle(RequestContext req, boolean isLogined, UserContext user) {
        if (isLogined) {
            if (!this.validateOnlyLogin) {
                HttpServletRequest httpReq = (HttpServletRequest)req.getAttribute("servletRequest");
                Principal up = httpReq.getUserPrincipal();
                if (up == null) {
                    return AutoLoginInstruction.LOGOUT;
                }
                if (!up.getName().equals(user.getAccount().getCredential().getId())) {
                    return new AutoLoginInstruction((Credential)new JeeContainerManagedCredential(up.getName()));
                }
            }
        } else {
            HttpServletRequest httpReq = (HttpServletRequest)req.getAttribute("servletRequest");
            Principal up = httpReq.getUserPrincipal();
            if (up != null) {
                return new AutoLoginInstruction((Credential)new JeeContainerManagedCredential(up.getName()));
            }
        }
        return AutoLoginInstruction.THROUGH;
    }
}

