/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.definition.TypedDefinitionManager;
import org.iplass.mtp.impl.definition.AbstractTypedMetaDataService;
import org.iplass.mtp.impl.definition.DefinitionMetaDataTypeMap;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.webapi.CorsConfig;
import org.iplass.mtp.impl.webapi.MetaWebApi;
import org.iplass.mtp.impl.webapi.StatusMap;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.webapi.definition.WebApiDefinition;
import org.iplass.mtp.webapi.definition.WebApiDefinitionManager;

public class WebApiService
extends AbstractTypedMetaDataService<MetaWebApi, MetaWebApi.WebApiRuntime>
implements Service {
    public static final String WEB_API_META_PATH = "/webapi/";
    private Map<Class<? extends Throwable>, Integer> statusMap;
    private Map<String, String> xRequestedWithMap;
    @Deprecated
    private CorsConfig cors;
    private boolean enableDefinitionApi;
    private boolean enableBinaryApi;

    public static String getFixedPath() {
        return WEB_API_META_PATH;
    }

    public void destroy() {
    }

    public void init(Config config) {
        this.statusMap = new HashMap<Class<? extends Throwable>, Integer>();
        List smList = config.getValues("statusMap", StatusMap.class);
        if (smList != null) {
            for (StatusMap sm : smList) {
                this.statusMap.put(sm.getException(), sm.getStatus());
            }
        }
        this.xRequestedWithMap = (Map)config.getValue("xRequestedWithMap", Map.class);
        this.cors = (CorsConfig)config.getValue("cors", CorsConfig.class);
        this.enableDefinitionApi = (Boolean)config.getValue("enableDefinitionApi", Boolean.class, (Object)Boolean.FALSE);
        this.enableBinaryApi = (Boolean)config.getValue("enableBinaryApi", Boolean.class, (Object)Boolean.FALSE);
    }

    public boolean isEnableDefinitionApi() {
        return this.enableDefinitionApi;
    }

    public boolean isEnableBinaryApi() {
        return this.enableBinaryApi;
    }

    @Deprecated
    public CorsConfig getCors() {
        return this.cors;
    }

    public Map<String, String> getXRequestedWithMap() {
        return this.xRequestedWithMap;
    }

    private String withHttpMethod(String path, String httpMethod) {
        if (path.endsWith("/")) {
            return path + httpMethod;
        }
        return path + "/" + httpMethod;
    }

    public MetaWebApi.WebApiRuntime getByPathHierarchy(String name, String httpMethod) {
        String withMethod;
        MetaDataContext context = MetaDataContext.getContext();
        if (httpMethod != null && context.exists(WEB_API_META_PATH, withMethod = this.withHttpMethod(name, httpMethod))) {
            return (MetaWebApi.WebApiRuntime)context.getMetaDataHandler(MetaWebApi.WebApiRuntime.class, WEB_API_META_PATH + withMethod);
        }
        if (context.exists(WEB_API_META_PATH, name)) {
            return (MetaWebApi.WebApiRuntime)context.getMetaDataHandler(MetaWebApi.WebApiRuntime.class, WEB_API_META_PATH + name);
        }
        String path = name;
        int index = -1;
        while ((index = path.lastIndexOf("/")) >= 0) {
            String pathWithMethod;
            path = path.substring(0, index);
            if (httpMethod != null && context.exists(WEB_API_META_PATH, pathWithMethod = this.withHttpMethod(path, httpMethod))) {
                return (MetaWebApi.WebApiRuntime)context.getMetaDataHandler(MetaWebApi.WebApiRuntime.class, WEB_API_META_PATH + pathWithMethod);
            }
            if (!context.exists(WEB_API_META_PATH, path)) continue;
            return (MetaWebApi.WebApiRuntime)context.getMetaDataHandler(MetaWebApi.WebApiRuntime.class, WEB_API_META_PATH + path);
        }
        return null;
    }

    public Class<MetaWebApi> getMetaDataType() {
        return MetaWebApi.class;
    }

    public Class<MetaWebApi.WebApiRuntime> getRuntimeType() {
        return MetaWebApi.WebApiRuntime.class;
    }

    public int mapStatus(Throwable e) {
        for (Class<?> type = e.getClass(); type != Throwable.class; type = type.getSuperclass()) {
            Integer status = this.statusMap.get(type);
            if (status == null) continue;
            return status;
        }
        return 500;
    }

    public static class TypeMap
    extends DefinitionMetaDataTypeMap<WebApiDefinition, MetaWebApi> {
        public TypeMap() {
            super(WebApiService.getFixedPath(), MetaWebApi.class, WebApiDefinition.class);
        }

        public TypedDefinitionManager<WebApiDefinition> typedDefinitionManager() {
            return (TypedDefinitionManager)ManagerLocator.getInstance().getManager(WebApiDefinitionManager.class);
        }
    }
}

