/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.template.report;

import java.io.Serializable;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.template.report.definition.ReportParamMapDefinition;

public class MetaReportParamMap
implements MetaData {
    private static final long serialVersionUID = -7418907290538937351L;
    private String name;
    private String mapFrom;
    private String paramType;
    private boolean convertEntityToMap;

    public MetaReportParamMap() {
    }

    public MetaReportParamMap(String name, String mapFrom) {
        this.name = name;
        this.mapFrom = mapFrom;
        this.paramType = "string";
    }

    public MetaReportParamMap(String name, String mapFrom, String paramType, boolean convertEntityToMap) {
        this.name = name;
        this.mapFrom = mapFrom;
        this.paramType = paramType;
        this.convertEntityToMap = convertEntityToMap;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMapFrom() {
        return this.mapFrom;
    }

    public void setMapFrom(String mapFrom) {
        this.mapFrom = mapFrom;
    }

    public String getParamType() {
        return this.paramType;
    }

    public void setParamType(String paramType) {
        this.paramType = paramType;
    }

    public boolean isConvertEntityToMap() {
        return this.convertEntityToMap;
    }

    public void setConvertEntityToMap(boolean convertEntityToMap) {
        this.convertEntityToMap = convertEntityToMap;
    }

    public void applyConfig(ReportParamMapDefinition definition) {
        this.name = definition.getName();
        this.mapFrom = definition.getMapFrom();
        this.paramType = StringUtil.isEmpty((String)definition.getParamType()) ? "string" : definition.getParamType();
        this.convertEntityToMap = definition.isConvertEntityToMap();
    }

    public ReportParamMapDefinition currentConfig() {
        ReportParamMapDefinition definition = new ReportParamMapDefinition();
        definition.setName(this.name);
        definition.setMapFrom(this.mapFrom);
        if (StringUtil.isEmpty((String)this.paramType)) {
            definition.setParamType("string");
        } else {
            definition.setParamType(this.paramType);
        }
        definition.setConvertEntityToMap(this.convertEntityToMap);
        return definition;
    }

    public MetaData copy() {
        return (MetaData)ObjectUtil.deepCopy((Serializable)((Object)this));
    }
}

