/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.iplass.mtp.impl.async.rdb.RdbQueueService;
import org.iplass.mtp.impl.cache.store.builtin.CacheEntryCleaner;
import org.iplass.mtp.runtime.EntryPoint;
import org.iplass.mtp.runtime.EntryPointBuilder;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInitializer
implements ServletContextListener {
    private static Logger logger = LoggerFactory.getLogger(ApplicationInitializer.class);
    protected EntryPoint entryPoint;

    public void contextDestroyed(ServletContextEvent event) {
        if (this.entryPoint != null) {
            logger.info("destroy all service");
            this.entryPoint.destroy();
            CacheEntryCleaner.shutdown();
            ILoggerFactory lf = LoggerFactory.getILoggerFactory();
            try {
                Method stopMethod;
                Class<?> logbackLoggerContextClass = Class.forName("ch.qos.logback.classic.LoggerContext");
                if (logbackLoggerContextClass.isAssignableFrom(lf.getClass()) && (stopMethod = logbackLoggerContextClass.getMethod("stop", new Class[0])) != null) {
                    stopMethod.invoke((Object)lf, new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected EntryPointBuilder createEntryPointBuilder(ServletContext sc) {
        String loader;
        String serverRole;
        String cryptConfigFileName;
        String serviceConfigFileName;
        EntryPointBuilder builder = EntryPoint.builder();
        String serverEnvFileName = sc.getInitParameter("mtp.server.env");
        if (serverEnvFileName != null) {
            logger.info("use " + serverEnvFileName + " as ServerEnvFile.");
            builder.serverEnvFile(serverEnvFileName);
        }
        if ((serviceConfigFileName = sc.getInitParameter("mtp.config")) != null) {
            logger.info("initialize with config:" + serviceConfigFileName);
            builder.config(serviceConfigFileName);
        }
        if ((cryptConfigFileName = sc.getInitParameter("mtp.config.crypt")) != null) {
            logger.debug("use cryptConfigFile:" + cryptConfigFileName);
            builder.crypt(cryptConfigFileName);
        }
        if ((serverRole = sc.getInitParameter("mtp.server.myserverroles")) != null) {
            logger.debug("use serverRoles:" + serverRole);
            builder.serverRole(new String[]{serverRole});
        }
        if ((loader = sc.getInitParameter("mtp.config.loader")) != null) {
            logger.debug("use configLoader:" + loader);
            builder.loader(loader);
        }
        return builder;
    }

    public void contextInitialized(ServletContextEvent e) {
        ServiceRegistry sr;
        if (!EntryPoint.isInited()) {
            ServletContext sc = e.getServletContext();
            EntryPointBuilder builder = this.createEntryPointBuilder(sc);
            this.entryPoint = builder.build();
        }
        if ((sr = ServiceRegistry.getRegistry()).exists(RdbQueueService.class)) {
            RdbQueueService rdbQueueService = (RdbQueueService)sr.getService(RdbQueueService.class);
        }
    }
}

