/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.csv;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.impl.entity.csv.EntityCsvReader;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;

public class EntityCsvReaderForCheck
extends EntityCsvReader {
    private int errorLimit;

    public EntityCsvReaderForCheck(EntityDefinition definition, InputStream inputStream, int errorLimit) throws UnsupportedEncodingException {
        super(definition, inputStream);
        this.errorLimit = errorLimit;
    }

    public EntityCsvReaderForCheck(EntityDefinition definition, InputStream inputStream, String charset, int errorLimit) throws UnsupportedEncodingException {
        super(definition, inputStream, charset);
        this.errorLimit = errorLimit;
    }

    public EntityCsvReaderForCheck(EntityDefinition definition, Reader reader, int errorLimit) {
        super(definition, reader);
        this.errorLimit = errorLimit;
    }

    public void check() {
        try {
            List list;
            this.init();
            ArrayList<String> errorMsgList = new ArrayList<String>();
            int cnt = 0;
            while ((list = this.readLine()) != null) {
                int start;
                ++cnt;
                try {
                    this.validateLine(list);
                }
                catch (EntityCsvException e) {
                    throw new EntityCsvException(e.getCode(), EntityCsvReaderForCheck.resourceString("impl.csv.EntityCsvReaderForCheck.rowError", cnt, e.getMessage()), (Throwable)e);
                }
                for (int i = start = this.isUseCtrl() ? 1 : 0; i < this.header().size(); ++i) {
                    String headerName = (String)this.header().get(i);
                    String value = (String)list.get(i);
                    try {
                        this.validateValue(headerName, value);
                        continue;
                    }
                    catch (EntityCsvException e) {
                        errorMsgList.add(EntityCsvReaderForCheck.resourceString("impl.csv.EntityCsvReaderForCheck.rowError", cnt, e.getMessage()));
                    }
                }
            }
            if (!errorMsgList.isEmpty()) {
                String errorMsg = EntityCsvReaderForCheck.resourceString("impl.csv.EntityCsvReaderForCheck.errorHead", new Object[0]);
                if (this.errorLimit < 0 || errorMsgList.size() <= this.errorLimit) {
                    for (String s : errorMsgList) {
                        errorMsg = errorMsg + "\n" + s;
                    }
                } else {
                    for (String s : errorMsgList.subList(0, this.errorLimit)) {
                        errorMsg = errorMsg + "\n" + s;
                    }
                    errorMsg = errorMsg + "\n...";
                }
                throw new EntityCsvException("CE1001", errorMsg);
            }
        }
        catch (IOException e) {
            throw new ApplicationException((Throwable)e);
        }
    }

    private static String resourceString(String key, Object ... arguments) {
        return WebResourceBundleUtil.resourceString(key, arguments);
    }
}

