/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.opaque;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.oauth.AccessTokenInfo;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenStore;
import org.iplass.mtp.impl.auth.oauth.AccessTokenAccountHandle;
import org.iplass.mtp.impl.auth.oauth.AccessTokenCredential;
import org.iplass.mtp.impl.auth.oauth.MetaClientPolicy;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.OAuthRuntimeException;
import org.iplass.mtp.impl.auth.oauth.token.opaque.AccessTokenMement;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OAuthServiceHolder;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OpaqueOAuthAccessTokenStore;
import org.iplass.mtp.impl.auth.oauth.token.opaque.RefreshTokenHandler;
import org.iplass.mtp.impl.auth.oauth.token.opaque.RefreshTokenMement;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.spi.Config;

public class AccessTokenHandler
extends AuthTokenHandler {
    public static final String TYPE_OAUTH_DEFAULT = "OAT";
    public static final String TYPE_OAUTH_REFRESH_DEFAULT = "ORT";
    private String refreshTokenStore;
    private String refreshTokenType;
    private String refreshTokenSecureRandomGeneratorName;
    private AccessTokenAuthTokenStore atatStore = new AccessTokenAuthTokenStore();
    private RefreshTokenHandler refreshTokenHandler;

    public RefreshTokenHandler refreshTokenHandler() {
        return this.refreshTokenHandler;
    }

    public String getRefreshTokenStore() {
        return this.refreshTokenStore;
    }

    public void setRefreshTokenStore(String refreshTokenStore) {
        this.refreshTokenStore = refreshTokenStore;
    }

    public String getRefreshTokenType() {
        return this.refreshTokenType;
    }

    public void setRefreshTokenType(String refreshTokenType) {
        this.refreshTokenType = refreshTokenType;
    }

    public String getRefreshTokenSecureRandomGeneratorName() {
        return this.refreshTokenSecureRandomGeneratorName;
    }

    public void setRefreshTokenSecureRandomGeneratorName(String refreshTokenSecureRandomGeneratorName) {
        this.refreshTokenSecureRandomGeneratorName = refreshTokenSecureRandomGeneratorName;
    }

    public void inited(AuthTokenService service, Config config) {
        super.inited(service, config);
        if (this.getType() == null) {
            this.setType(TYPE_OAUTH_DEFAULT);
        }
        this.refreshTokenHandler = new RefreshTokenHandler();
        if (this.refreshTokenStore != null) {
            this.refreshTokenHandler.setStore(this.refreshTokenStore);
        }
        if (this.refreshTokenType != null) {
            this.refreshTokenHandler.setType(this.refreshTokenType);
        } else {
            this.refreshTokenHandler.setType(TYPE_OAUTH_REFRESH_DEFAULT);
        }
        if (this.refreshTokenSecureRandomGeneratorName != null) {
            this.refreshTokenHandler.setSecureRandomGeneratorName(this.refreshTokenSecureRandomGeneratorName);
        }
        this.refreshTokenHandler.setHashSettings(this.getHashSettings());
        this.refreshTokenHandler.inited(service, config);
    }

    public AuthTokenStore authTokenStore() {
        return this.atatStore;
    }

    public AuthTokenInfo toAuthTokenInfo(AuthToken authToken) {
        AccessTokenInfo info = new AccessTokenInfo();
        info.setType(this.getType());
        info.setKey(authToken.getSeries());
        info.setStartDate(authToken.getStartDate());
        ((AccessTokenMement)authToken.getDetails()).fill(info);
        return info;
    }

    public Credential toCredential(AuthToken newToken) {
        AccessTokenCredential cre = new AccessTokenCredential(newToken.encodeToken());
        return cre;
    }

    protected Serializable createDetails(String seriesString, String tokenString, String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        AccessTokenMement mement = new AccessTokenMement();
        AccessTokenInfo info = (AccessTokenInfo)tokenInfo;
        MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeByName(info.getClientName());
        MetaOAuthAuthorization.OAuthAuthorizationRuntime server = client.getAuthorizationServer();
        MetaClientPolicy.ClientPolicyRuntime cp = server.getClientPolicy(client.getMetaData().getClientType());
        long expires = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(cp.getMetaData().getAccessTokenLifetimeSeconds());
        AccessTokenAccountHandle dummy = new AccessTokenAccountHandle(userUniqueId, null, null);
        User user = OAuthServiceHolder.userEntityResolver.searchUser((AccountHandle)dummy);
        if (user == null) {
            throw new OAuthRuntimeException("can not search User:" + userUniqueId);
        }
        if (server.getSubjectIdentifierType() != null) {
            user = server.getSubjectIdentifierType().handleOnLoad(user);
        }
        mement.save(info, expires, userUniqueId, user);
        return mement;
    }

    public String newSeriesString(String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        AccessTokenInfo ati = (AccessTokenInfo)tokenInfo;
        MetaOAuthClient.OAuthClientRuntime clientRuntime = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeByName(ati.getClientName());
        return ((OpaqueOAuthAccessTokenStore)OAuthServiceHolder.authorization.getAccessTokenStore()).toSeriesString(clientRuntime, userUniqueId);
    }

    private class AccessTokenAuthTokenStore
    implements AuthTokenStore {
        private AccessTokenAuthTokenStore() {
        }

        public AuthToken getBySeries(int tenantId, String type, String series) {
            return AccessTokenHandler.super.authTokenStore().getBySeries(tenantId, type, series);
        }

        public List<AuthToken> getByOwner(int tenantId, String type, String ownerId) {
            return AccessTokenHandler.super.authTokenStore().getByOwner(tenantId, type, ownerId);
        }

        public void create(AuthToken token) {
            AccessTokenHandler.super.authTokenStore().create(token);
            AccessTokenMement mement = (AccessTokenMement)token.getDetails();
            MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeById(mement.getClientMetaDataId());
            MetaOAuthAuthorization.OAuthAuthorizationRuntime authorizationServer = client.getAuthorizationServer();
            if (authorizationServer.getClientPolicy(client.getMetaData().getClientType()).isRequireRefreshToken(mement.getGrantedScopes())) {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                AccessTokenHandler.this.refreshTokenHandler.authTokenStore().deleteBySeries(tenantId, AccessTokenHandler.this.refreshTokenHandler.getType(), token.getSeries());
                AuthToken refreshToken = AccessTokenHandler.this.refreshTokenHandler.newAuthToken(token.getOwnerId(), token.getPolicyName(), new RefreshTokenMement.RefreshTokenInfo(client.getMetaData().getName()));
                AccessTokenHandler.this.refreshTokenHandler.authTokenStore().create(refreshToken);
                mement.setRefreshToken(refreshToken);
            }
        }

        public void update(AuthToken newToken, AuthToken currentToken) {
            MetaOAuthClient.OAuthClientRuntime client;
            MetaOAuthAuthorization.OAuthAuthorizationRuntime authorizationServer;
            AccessTokenHandler.super.authTokenStore().update(newToken, currentToken);
            AccessTokenMement newMement = (AccessTokenMement)newToken.getDetails();
            AccessTokenMement currentMement = (AccessTokenMement)currentToken.getDetails();
            if (newMement.getGrantedScopes() != null && newMement.getGrantedScopes().contains("offline_access") && (currentMement.getGrantedScopes() == null || !currentMement.getGrantedScopes().contains("offline_access")) && (authorizationServer = (client = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeById(newMement.getClientMetaDataId())).getAuthorizationServer()).getClientPolicy(client.getMetaData().getClientType()).isRequireRefreshToken(newMement.getGrantedScopes())) {
                int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
                AccessTokenHandler.this.refreshTokenHandler.authTokenStore().deleteBySeries(tenantId, AccessTokenHandler.this.refreshTokenHandler.getType(), newToken.getSeries());
                AuthToken refreshToken = AccessTokenHandler.this.refreshTokenHandler.newAuthToken(newToken.getOwnerId(), newToken.getPolicyName(), new RefreshTokenMement.RefreshTokenInfo(client.getMetaData().getName()));
                AccessTokenHandler.this.refreshTokenHandler.authTokenStore().create(refreshToken);
                newMement.setRefreshToken(refreshToken);
            }
        }

        public void delete(int tenantId, String type, String ownerId) {
            AccessTokenHandler.super.authTokenStore().delete(tenantId, type, ownerId);
            AccessTokenHandler.this.refreshTokenHandler.authTokenStore().delete(tenantId, AccessTokenHandler.this.refreshTokenHandler.getType(), ownerId);
        }

        public void deleteBySeries(int tenantId, String type, String series) {
            AccessTokenHandler.super.authTokenStore().deleteBySeries(tenantId, type, series);
            AccessTokenHandler.this.refreshTokenHandler.authTokenStore().deleteBySeries(tenantId, AccessTokenHandler.this.refreshTokenHandler.getType(), series);
        }

        public void deleteByDate(int tenantId, String type, Timestamp ts) {
            AccessTokenHandler.super.authTokenStore().deleteByDate(tenantId, type, ts);
            AccessTokenHandler.this.refreshTokenHandler.authTokenStore().deleteByDate(tenantId, AccessTokenHandler.this.refreshTokenHandler.getType(), ts);
        }
    }
}

