/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.introspectors;

import java.util.Map;
import org.iplass.mtp.auth.oauth.definition.CustomTokenIntrospectorDefinition;
import org.iplass.mtp.auth.oauth.definition.introspectors.ScriptingCustomTokenIntrospectorDefinition;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.impl.auth.oauth.MetaCustomTokenIntrospector;
import org.iplass.mtp.impl.auth.oauth.token.AccessToken;
import org.iplass.mtp.impl.command.RequestContextBinding;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;

public class MetaScriptingCustomTokenIntrospector
extends MetaCustomTokenIntrospector {
    private static final long serialVersionUID = 7094142390799872996L;
    private static final String REQUEST_BINDING_NAME = "request";
    private static final String RESPONSE_BINDING_NAME = "response";
    private static final String RESOURCE_OWNER_BINDING_NAME = "resourceOwner";
    private String script;

    public MetaScriptingCustomTokenIntrospector() {
    }

    public MetaScriptingCustomTokenIntrospector(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public void applyConfig(CustomTokenIntrospectorDefinition def) {
        this.script = ((ScriptingCustomTokenIntrospectorDefinition)def).getScript();
    }

    @Override
    public CustomTokenIntrospectorDefinition currentConfig() {
        ScriptingCustomTokenIntrospectorDefinition def = new ScriptingCustomTokenIntrospectorDefinition();
        def.setScript(this.script);
        return def;
    }

    @Override
    public MetaCustomTokenIntrospector.CustomTokenIntrospectorRuntime createRuntime(String metaId, int index) {
        return new ScriptingCustomTokenIntrospectorRuntime(metaId, index);
    }

    public class ScriptingCustomTokenIntrospectorRuntime
    extends MetaCustomTokenIntrospector.CustomTokenIntrospectorRuntime {
        private static final String SCRIPT_PREFIX = "ScriptingCustomTokenIntrospector";
        private Script scriptRuntime;

        private ScriptingCustomTokenIntrospectorRuntime(String metaId, int index) {
            super(MetaScriptingCustomTokenIntrospector.this);
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptRuntime = tc.getScriptEngine().createScript(MetaScriptingCustomTokenIntrospector.this.script, "ScriptingCustomTokenIntrospector_" + metaId + "_" + index);
        }

        @Override
        public boolean handle(Map<String, Object> response, RequestContext request, AccessToken token) {
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            TenantContext tc = ex.getTenantContext();
            ScriptEngine scriptEngine = tc.getScriptEngine();
            ScriptContext sc = scriptEngine.newScriptContext();
            sc.setAttribute(MetaScriptingCustomTokenIntrospector.REQUEST_BINDING_NAME, (Object)new RequestContextBinding(request));
            sc.setAttribute(MetaScriptingCustomTokenIntrospector.RESPONSE_BINDING_NAME, response);
            sc.setAttribute(MetaScriptingCustomTokenIntrospector.RESOURCE_OWNER_BINDING_NAME, (Object)token.getUser());
            Boolean ret = (Boolean)this.scriptRuntime.eval(sc);
            return ret != null && ret != false;
        }

        @Override
        public MetaCustomTokenIntrospector getMetaData() {
            return MetaScriptingCustomTokenIntrospector.this;
        }
    }
}

