/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.command;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.cache.CacheCriteria;
import org.iplass.mtp.impl.auth.oauth.OAuthAuthorizationService;
import org.iplass.mtp.impl.auth.oauth.jwt.CertificateKeyPair;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtKeyStore;
import org.iplass.mtp.impl.auth.oauth.jwt.JwtProcessor;
import org.iplass.mtp.spi.ServiceRegistry;

@ActionMapping(name="oauth/jwks", publicAction=true, clientCacheType=ActionMapping.ClientCacheType.CACHE, clientCacheMaxAge=3600L, result={@Result(type=Result.Type.STREAM, contentTypeAttributeName="contentType")}, cacheCriteria=@CacheCriteria(type=CacheCriteria.Type.PARAMETER_MATCH, timeToLive=3600000))
@CommandClass(name="mtp/oauth/JwksCommand", displayName="JWK Set Uri", readOnly=true)
public class JwksCommand
implements Command {
    static final String STAT_SUCCESS = "SUCCESS";
    private OAuthAuthorizationService service = (OAuthAuthorizationService)ServiceRegistry.getRegistry().getService(OAuthAuthorizationService.class);
    private ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public String execute(RequestContext request) {
        HashMap res = new HashMap();
        ArrayList<Map<String, Object>> keys = new ArrayList<Map<String, Object>>();
        res.put("keys", keys);
        String jwkSet = null;
        JwtKeyStore keyStore = this.service.getJwtKeyStore();
        if (keyStore != null) {
            JwtProcessor jwtProcessor = this.service.getJwtProcessor();
            List<CertificateKeyPair> keyList = keyStore.list();
            for (CertificateKeyPair ckp : keyList) {
                keys.add(ckp.toPublicJwkMap(jwtProcessor.preferredAlgorithm(ckp)));
            }
            try {
                jwkSet = this.objectMapper.writeValueAsString(res);
            }
            catch (JsonProcessingException e) {
                throw new SystemException((Throwable)e);
            }
        } else {
            jwkSet = "{\"keys\": []}";
        }
        try {
            request.setAttribute("streamData", (Object)jwkSet.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException((Throwable)e);
        }
        request.setAttribute("contentType", (Object)"application/json;charset=utf-8");
        return STAT_SUCCESS;
    }
}

