/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.command;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.NeedTrustedAuthenticationException;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.template.Template;
import org.iplass.mtp.command.annotation.template.Templates;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthAuthorization;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.OAuthApplicationException;
import org.iplass.mtp.impl.auth.oauth.OAuthClientService;
import org.iplass.mtp.impl.auth.oauth.OAuthRuntimeException;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationCode;
import org.iplass.mtp.impl.auth.oauth.code.AuthorizationRequest;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.actionmapping.definition.HttpMethodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ActionMapping(name="oauth/authorize", clientCacheType=ActionMapping.ClientCacheType.NO_CACHE, allowMethod={HttpMethodType.GET, HttpMethodType.POST}, publicAction=true, result={@Result(status="SUCCESS_REDIRECT", type=Result.Type.REDIRECT, allowExternalLocation=true, value="redirectPath"), @Result(status="SUCCESS_POST", type=Result.Type.TEMPLATE, value="oauth/OAuthPost"), @Result(status="NEED_CONSENT", type=Result.Type.DYNAMIC, value="templateName"), @Result(status="ERROR_REDIRECT", type=Result.Type.REDIRECT, allowExternalLocation=true, value="redirectPath"), @Result(status="ERROR_POST", type=Result.Type.TEMPLATE, value="oauth/OAuthPost")})
@Templates(value={@Template(name="oauth/OAuthPost", displayName="OAuth Post Response Mode", path="/jsp/oauth/OAuthPost.jsp", contentType="text/html; charset=utf-8"), @Template(name="oauth/Consent", displayName="Default OAuth Consent View", path="/jsp/oauth/Consent.jsp", contentType="text/html; charset=utf-8")})
@CommandClass(name="mtp/oauth/AuthorizeCommand", displayName="OAuth2.0 Authorization Endpoint")
public class AuthorizeCommand
implements Command {
    static final String PARAM_DEFINITION_NAME = "defName";
    static final String PARAM_RESPONSE_TYPE = "response_type";
    static final String PARAM_CLIENT_ID = "client_id";
    static final String PARAM_REDIRECT_URI = "redirect_uri";
    static final String PARAM_SCOPE = "scope";
    static final String PARAM_STATE = "state";
    static final String PARAM_CODE = "code";
    static final String PARAM_RESPONSE_MODE = "response_mode";
    static final String PARAM_ERROR = "error";
    static final String PARAM_ERROR_DESCRIPTION = "error_description";
    static final String PARAM_CODE_CHALLENGE = "code_challenge";
    static final String PARAM_CODE_CHALLENGE_METHOD = "code_challenge_method";
    static final String PARAM_NONCE = "nonce";
    static final String PARAM_PROMPT = "prompt";
    static final String PARAM_MAX_AGE = "max_age";
    static final String STAT_SUCCESS_REDIRECT = "SUCCESS_REDIRECT";
    static final String STAT_SUCCESS_POST = "SUCCESS_POST";
    static final String STAT_ERROR_REDIRECT = "ERROR_REDIRECT";
    static final String STAT_ERROR_POST = "ERROR_POST";
    static final String STAT_NEED_CONSENT = "NEED_CONSENT";
    static final String REQUEST_TMPL_NAME = "templateName";
    static final String REQUEST_AUTHORIZATION_CODE = "authorizationCode";
    static final String REQUEST_AUTHORIZATION_REQUEST = "authorizationRequest";
    static final String REQUEST_ERROR = "error";
    public static final String SESSION_AUTHORIZATION_REQUEST = "authorizationRequest";
    public static final String TMPL_POST = "oauth/OAuthPost";
    public static final String TMPL_CONSENT = "oauth/Consent";
    private static Logger logger = LoggerFactory.getLogger(AuthorizeCommand.class);
    private OAuthClientService clientService = (OAuthClientService)ServiceRegistry.getRegistry().getService(OAuthClientService.class);

    public String execute(RequestContext request) {
        String clientId = request.getParam(PARAM_CLIENT_ID);
        MetaOAuthClient.OAuthClientRuntime clientRuntime = (MetaOAuthClient.OAuthClientRuntime)this.clientService.getRuntimeByName(clientId);
        if (clientRuntime == null) {
            throw new OAuthRuntimeException("invalid client_id:" + clientId);
        }
        String redirectUri = StringUtil.stripToNull((String)request.getParam(PARAM_REDIRECT_URI));
        String validRedirectUri = clientRuntime.selectValidRedirectUri(redirectUri);
        if (validRedirectUri == null) {
            throw new OAuthRuntimeException("invalid redirect_uri:" + redirectUri);
        }
        MetaOAuthAuthorization.OAuthAuthorizationRuntime authRuntime = clientRuntime.getAuthorizationServer();
        AuthorizationRequest authReq = new AuthorizationRequest(authRuntime.getMetaData().getName(), clientRuntime.getMetaData().getName(), validRedirectUri);
        authReq.setState(StringUtil.stripToNull((String)request.getParam(PARAM_STATE)));
        authReq.setCodeChallenge(StringUtil.stripToNull((String)request.getParam(PARAM_CODE_CHALLENGE)));
        authReq.setCodeChallengeMethod(StringUtil.stripToNull((String)request.getParam(PARAM_CODE_CHALLENGE_METHOD)));
        authReq.addResponseTypes(StringUtil.split((String)request.getParam(PARAM_RESPONSE_TYPE), (char)' '));
        authReq.addScopes(StringUtil.split((String)request.getParam(PARAM_SCOPE), (char)' '));
        authReq.setResponseMode(StringUtil.stripToNull((String)request.getParam(PARAM_RESPONSE_MODE)));
        authReq.setNonce(StringUtil.stripToNull((String)request.getParam(PARAM_NONCE)));
        authReq.addPrompts(StringUtil.split((String)request.getParam(PARAM_PROMPT), (char)' '));
        authReq.setMaxAge(request.getParamAsLong(PARAM_MAX_AGE));
        try {
            authRuntime.checkValidAuthorizationRequest(authReq);
            AuthContext ac = AuthContext.getCurrentContext();
            if (ac.isAuthenticated() && !authReq.hasPrompt("login")) {
                if (authReq.getMaxAge() != null && ac.getAuthTime() + TimeUnit.SECONDS.toMillis(authReq.getMaxAge()) < System.currentTimeMillis()) {
                    if (authReq.hasPrompt("none")) {
                        throw new OAuthApplicationException("login_required", "Login required.");
                    }
                    throw new NeedTrustedAuthenticationException();
                }
            } else {
                if (authReq.hasPrompt("none")) {
                    throw new OAuthApplicationException("login_required", "Login required.");
                }
                throw new NeedTrustedAuthenticationException();
            }
            if (!authRuntime.hasAvailableRole()) {
                throw new OAuthApplicationException("access_denied", "User can't access this resource.");
            }
            if (authReq.hasPrompt("consent") || authRuntime.isNeedConsent(request, authReq)) {
                if (authReq.getPrompt() != null && authReq.getPrompt().contains("none")) {
                    throw new OAuthApplicationException("consent_required", "Consent required.");
                }
                return this.needConsent(request, authReq, authRuntime);
            }
            authReq.getScopes().remove("offline_access");
            AuthorizationCode code = authRuntime.generateCode(authReq);
            return this.success(request, code);
        }
        catch (NeedTrustedAuthenticationException e) {
            throw e;
        }
        catch (OAuthApplicationException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)((Object)e));
            }
            return this.error(request, e.getCode(), e.getDescription(), authReq);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return this.error(request, "server_error", "See server log for details.", authReq);
        }
    }

    private String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String createRedirectUri(AuthorizationRequest authReq, Consumer<StringBuilder> appender) {
        StringBuilder redirectUri = new StringBuilder();
        redirectUri.append(authReq.getRedirectUri());
        if (authReq.getResponseMode() == null || authReq.getResponseMode().equals("query")) {
            if (authReq.getRedirectUri().contains("?")) {
                redirectUri.append('&');
            } else {
                redirectUri.append('?');
            }
        } else if (authReq.getResponseMode().equals("fragment")) {
            redirectUri.append('#');
        }
        appender.accept(redirectUri);
        return redirectUri.toString();
    }

    String success(RequestContext request, AuthorizationCode code) {
        if ("form_post".equals(code.getRequest().getResponseMode())) {
            request.setAttribute("authorizationRequest", (Object)code.getRequest());
            request.setAttribute(REQUEST_AUTHORIZATION_CODE, (Object)code);
            return STAT_SUCCESS_POST;
        }
        String redirectUri = this.createRedirectUri(code.getRequest(), sb -> {
            sb.append(PARAM_CODE).append('=').append(this.encode(code.getCodeValue()));
            if (code.getRequest().getState() != null) {
                sb.append('&').append(PARAM_STATE).append('=').append(this.encode(code.getRequest().getState()));
            }
        });
        request.setAttribute("redirectPath", (Object)redirectUri.toString());
        return STAT_SUCCESS_REDIRECT;
    }

    String error(RequestContext request, String errorCode, String errorDescription, AuthorizationRequest authReq) {
        if ("form_post".equals(authReq.getResponseMode())) {
            request.setAttribute("authorizationRequest", (Object)authReq);
            request.setAttribute("error", (Object)new OAuthApplicationException(errorCode, errorDescription));
            return STAT_ERROR_POST;
        }
        String redirectUri = this.createRedirectUri(authReq, sb -> {
            sb.append("error").append('=').append(this.encode(errorCode));
            if (errorDescription != null) {
                sb.append('&').append(PARAM_ERROR_DESCRIPTION).append('=').append(this.encode(errorDescription));
            }
            if (authReq.getState() != null) {
                sb.append('&').append(PARAM_STATE).append('=').append(this.encode(authReq.getState()));
            }
        });
        request.setAttribute("redirectPath", (Object)redirectUri.toString());
        return STAT_ERROR_REDIRECT;
    }

    String needConsent(RequestContext request, AuthorizationRequest authReq, MetaOAuthAuthorization.OAuthAuthorizationRuntime authRuntime) {
        request.getSession().setAttribute("authorizationRequest", (Object)authReq);
        request.setAttribute(REQUEST_TMPL_NAME, (Object)authRuntime.consentTemplateName());
        return STAT_NEED_CONSENT;
    }
}

