/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.action;

import java.util.ArrayList;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.authorize.builtin.AuthorizationContextCacheLogic;
import org.iplass.mtp.impl.auth.authorize.builtin.BuiltinAuthorizationContext;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.action.ActionPermissionEntry;
import org.iplass.mtp.impl.auth.authorize.builtin.action.BuiltinActionAuthContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActionAuthContextCacheLogic
extends AuthorizationContextCacheLogic {
    private static final Logger logger = LoggerFactory.getLogger(ActionAuthContextCacheLogic.class);
    public static final String ACTION_PERMISSION_DEF_NAME = "mtp.auth.ActionPermission";
    public static final String ACTION_PATH = "targetAction";
    public static final String ACTION_CONDITION = "conditionExpression";
    public static final String ACTION_ROLE = "role";
    private EntityManager em = (EntityManager)ManagerLocator.getInstance().getManager(EntityManager.class);

    ActionAuthContextCacheLogic(TenantAuthorizeContext authorizeContext) {
        super(authorizeContext);
    }

    protected BuiltinAuthorizationContext loadImpl(String key) {
        return (BuiltinAuthorizationContext)AuthContext.doPrivileged(() -> {
            Query q = new Query().select(new Object[]{"oid", ACTION_CONDITION, "role.code"}).from(ACTION_PERMISSION_DEF_NAME).where((Condition)new Equals(ACTION_PATH, (Object)key));
            ArrayList entries = new ArrayList();
            this.em.search(q, dataModel -> {
                if (dataModel[2] != null) {
                    ActionPermissionEntry e = new ActionPermissionEntry((String)dataModel[2], (String)dataModel[0], (String)dataModel[1]);
                    entries.add(e);
                } else {
                    logger.warn("role code not defined. so ignore this entry:oid=" + dataModel[0]);
                }
                return true;
            });
            if (entries.size() == 0) {
                return null;
            }
            return new BuiltinActionAuthContext(key, entries.toArray(new ActionPermissionEntry[entries.size()]), this.authorizeContext);
        });
    }
}

