/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;
import java.util.ArrayList;
import org.iplass.mtp.impl.webapi.WebApiParameter;
import org.iplass.mtp.impl.webapi.jackson.WebApiObjectMapperService;
import org.iplass.mtp.spi.ServiceRegistry;

public class WebApiParameterDeserializer
extends JsonDeserializer<WebApiParameter> {
    public static final String NAME_PROPERTY_NAME = "name";
    public static final String VALUE_PROPERTY_NAME = "value";
    public static final String VALUE_TYPE_PROPERTY_NAME = "valueType";
    private WebApiObjectMapperService mapperService = (WebApiObjectMapperService)ServiceRegistry.getRegistry().getService(WebApiObjectMapperService.class);

    WebApiParameterDeserializer() {
    }

    public WebApiParameter deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            jp.nextToken();
        }
        WebApiParameter param = new WebApiParameter();
        JsonNode valueNode = null;
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            jp.nextToken();
            if (NAME_PROPERTY_NAME.equals(propName)) {
                String name = jp.getText();
                if (name == null) {
                    throw ctxt.mappingException("name is null.");
                }
                param.setName(name);
            } else if (VALUE_TYPE_PROPERTY_NAME.equals(propName)) {
                String valType = jp.getText();
                if (valType == null) {
                    throw ctxt.mappingException("valueType is null.");
                }
                param.setValueType(valType);
            } else if (VALUE_PROPERTY_NAME.equals(propName)) {
                if (param.getValueType() != null) {
                    param.setValue(this.readValue(param.getValueType(), jp, ctxt));
                } else {
                    valueNode = (JsonNode)jp.readValueAsTree();
                }
            } else {
                jp.skipChildren();
            }
            jp.nextToken();
        }
        if (valueNode != null) {
            TreeTraversingParser ttp = new TreeTraversingParser(valueNode, jp.getCodec());
            if (param.getValueType() != null) {
                param.setValue(this.readValue(param.getValueType(), (JsonParser)ttp, ctxt));
            } else {
                param.setValue(ttp.readValueAs(Object.class));
            }
        }
        return param;
    }

    private Object readValue(String valueType, JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Class<?> cl = this.mapperService.getMappedClass(valueType);
        if (cl == null) {
            throw ctxt.mappingException("unknown valueType:" + valueType);
        }
        switch (jp.getCurrentToken()) {
            case START_ARRAY: {
                jp.nextToken();
                ArrayList<Object> array = new ArrayList<Object>();
                while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                    if (jp.getCurrentToken() == JsonToken.VALUE_NULL) {
                        array.add(null);
                    } else {
                        array.add(jp.readValueAs(cl));
                    }
                    jp.nextToken();
                }
                return array;
            }
        }
        return jp.readValueAs(cl);
    }
}

