/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;

public class EntitySerializer
extends StdSerializer<Entity> {
    private static final long serialVersionUID = -8460188948114932009L;
    public static final String PROP_DEFINITION_NAME = "definitionName";

    public EntitySerializer() {
        super(Entity.class);
    }

    public EntitySerializer(Class<?> t, boolean dummy) {
        super(t, dummy);
    }

    public EntitySerializer(Class<Entity> t) {
        super(t);
    }

    public EntitySerializer(JavaType type) {
        super(type);
    }

    public EntitySerializer(StdSerializer<?> src) {
        super(src);
    }

    public void serialize(Entity value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        boolean writeNull;
        boolean bl = writeNull = provider.getConfig().getDefaultPropertyInclusion().getValueInclusion() == JsonInclude.Include.ALWAYS;
        if (value instanceof GenericEntity) {
            gen.writeStartObject((Object)value);
            gen.writeStringField(PROP_DEFINITION_NAME, value.getDefinitionName());
            for (String pname : ((GenericEntity)value).getPropertyNames()) {
                this.writeProp(pname, value, gen, writeNull);
            }
            gen.writeEndObject();
        } else {
            EntityContext ec = EntityContext.getCurrentContext();
            EntityHandler eh = ec.getHandlerByName(value.getDefinitionName());
            if (eh == null) {
                throw provider.mappingException("cant find Entity Defs... definitionName:" + value.getDefinitionName(), new Object[0]);
            }
            gen.writeStartObject((Object)value);
            gen.writeStringField(PROP_DEFINITION_NAME, value.getDefinitionName());
            for (PropertyHandler ph : eh.getPropertyList(ec)) {
                this.writeProp(ph.getName(), value, gen, writeNull);
            }
            gen.writeEndObject();
        }
    }

    private void writeProp(String propName, Entity entity, JsonGenerator gen, boolean writeNull) throws IOException {
        Object propVal = entity.getValue(propName);
        if (writeNull || propVal != null) {
            if (propVal instanceof Object[]) {
                Object[] arrayVal = (Object[])propVal;
                gen.writeArrayFieldStart(propName);
                for (Object v : arrayVal) {
                    this.writeValue(v, gen);
                }
                gen.writeEndArray();
            } else {
                gen.writeFieldName(propName);
                this.writeValue(propVal, gen);
            }
        }
    }

    private void writeValue(Object value, JsonGenerator gen) throws IOException {
        if (value == null) {
            gen.writeNull();
        } else {
            gen.writeObject(value);
        }
    }
}

