/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.ibm.icu.math.BigDecimal;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.Map;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.properties.extend.ExpressionType;
import org.iplass.mtp.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDeserializer
extends StdDeserializer<Entity> {
    private static final long serialVersionUID = 8180920461950919037L;
    private static Logger logger = LoggerFactory.getLogger(EntityDeserializer.class);

    public EntityDeserializer() {
        super(Entity.class);
    }

    public EntityDeserializer(Class<?> vc) {
        super(vc);
    }

    public EntityDeserializer(JavaType valueType) {
        super(valueType);
    }

    public EntityDeserializer(StdDeserializer<?> src) {
        super(src);
    }

    private Object getValue(EntityContext ec, EntityHandler eh, PropertyHandler ph, JsonNode node, DeserializationContext ctxt) throws IOException {
        if (node.isNull()) {
            return null;
        }
        PropertyDefinitionType pdType = ph.getEnumType();
        if (pdType == PropertyDefinitionType.EXPRESSION) {
            ExpressionType et = (ExpressionType)((PrimitivePropertyHandler)ph).getMetaData().getType();
            pdType = et.getResultType() != null ? et.getResultType() : PropertyDefinitionType.STRING;
        }
        switch (pdType) {
            case AUTONUMBER: 
            case LONGTEXT: 
            case STRING: {
                return node.asText();
            }
            case BINARY: {
                if (node.isObject()) {
                    return node.traverse(ctxt.getParser().getCodec()).readValueAs(BinaryReference.class);
                }
                BinaryReference br = new BinaryReference();
                br.setLobId(node.asLong());
                return br;
            }
            case BOOLEAN: {
                return node.asBoolean();
            }
            case DATE: {
                String dateStr = node.asText();
                SimpleDateFormat sdf = DateUtil.getSimpleDateFormat((String)"yyyy-MM-dd", (boolean)false);
                try {
                    return new Date(sdf.parse(dateStr).getTime());
                }
                catch (ParseException e) {
                    throw ctxt.mappingException("cant parse to Date. date:" + dateStr);
                }
            }
            case DATETIME: {
                return new Timestamp(ctxt.parseDate(node.asText()).getTime());
            }
            case TIME: {
                String timeStr = node.asText();
                SimpleDateFormat sdfTime = DateUtil.getSimpleDateFormat((String)"HH:mm:ss", (boolean)false);
                try {
                    return sdfTime.parse(timeStr);
                }
                catch (ParseException e) {
                    throw ctxt.mappingException("cant parse to Date. date:" + timeStr);
                }
            }
            case DECIMAL: {
                String decStr = node.asText();
                return new BigDecimal(decStr);
            }
            case FLOAT: {
                return node.asDouble();
            }
            case INTEGER: {
                return node.asLong();
            }
            case REFERENCE: {
                EntityHandler refEh = ((ReferencePropertyHandler)ph).getReferenceEntityHandler(ec);
                return this.toEntity(ec, refEh, node, ctxt);
            }
            case SELECT: {
                if (node.isObject()) {
                    return node.traverse(ctxt.getParser().getCodec()).readValueAs(SelectValue.class);
                }
                SelectValue sv = new SelectValue();
                sv.setValue(node.asText());
                return sv;
            }
        }
        return null;
    }

    private Entity toEntity(EntityContext ec, EntityHandler eh, JsonNode node, DeserializationContext ctxt) throws IOException {
        Entity entity = eh.newInstance();
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            PropertyHandler ph = eh.getProperty((String)e.getKey(), ec);
            if (ph == null) {
                if ("definitionName".equals(e.getKey())) continue;
                logger.warn("unknown property name:" + (String)e.getKey() + " of Entity:" + eh.getMetaData().getName() + ", so ignore value");
                continue;
            }
            Object propVal = null;
            Object[] arrayVal = null;
            JsonNode value = (JsonNode)e.getValue();
            if (value != null && !value.isNull()) {
                if (value.isArray()) {
                    if (ph.getMetaData().getMultiplicity() == 1) {
                        if (value.size() > 0) {
                            propVal = this.getValue(ec, eh, ph, value.get(0), ctxt);
                        }
                    } else {
                        arrayVal = ph.newArrayInstance(value.size(), ec);
                        for (int i = 0; i < arrayVal.length; ++i) {
                            arrayVal[i] = this.getValue(ec, eh, ph, value.get(i), ctxt);
                        }
                    }
                } else if (ph.getMetaData().getMultiplicity() == 1) {
                    propVal = this.getValue(ec, eh, ph, value, ctxt);
                } else {
                    arrayVal = ph.newArrayInstance(1, ec);
                    arrayVal[0] = this.getValue(ec, eh, ph, value, ctxt);
                }
            }
            if (propVal != null) {
                entity.setValue((String)e.getKey(), propVal);
            }
            if (arrayVal == null) continue;
            entity.setValue((String)e.getKey(), arrayVal);
        }
        return entity;
    }

    public Entity deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        EntityHandler eh;
        JsonNode buf = (JsonNode)jp.getCodec().readTree(jp);
        EntityContext ec = EntityContext.getCurrentContext();
        String defName = null;
        JsonNode defNode = buf.get("definitionName");
        if (defNode != null) {
            defName = defNode.asText();
        }
        if ((eh = ec.getHandlerByName(defName)) == null) {
            throw ctxt.mappingException("cant find Entity Defs... definitionName:" + defName);
        }
        return this.toEntity(ec, eh, buf, ctxt);
    }
}

