/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.interceptors;

import javax.servlet.http.HttpServletRequest;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.interceptor.CommandInterceptor;
import org.iplass.mtp.command.interceptor.CommandInvocation;
import org.iplass.mtp.impl.web.WebResourceBundleUtil;
import org.iplass.mtp.impl.web.token.TokenStore;
import org.iplass.mtp.impl.webapi.MetaWebApi;
import org.iplass.mtp.impl.webapi.MetaWebApiTokenCheck;
import org.iplass.mtp.impl.webapi.WebApiInvocationImpl;
import org.iplass.mtp.web.actionmapping.TokenValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenInterceptor
implements CommandInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(TokenInterceptor.class);

    public String intercept(CommandInvocation invocation) {
        if (invocation instanceof WebApiInvocationImpl) {
            MetaWebApi.WebApiRuntime runtime = ((WebApiInvocationImpl)invocation).getWebApiRuntime();
            RequestContext context = invocation.getRequest();
            MetaWebApiTokenCheck tokenCheck = runtime.getMetaData().getTokenCheck();
            if (tokenCheck != null) {
                TokenStore tokenStore;
                logger.trace("execute validate token...");
                boolean isValid = false;
                String token = context.getParam("_t");
                if (token == null) {
                    HttpServletRequest request = (HttpServletRequest)context.getAttribute("servletRequest");
                    token = request.getHeader("X-Transaction-Token");
                }
                if (token == null) {
                    this.tokenError(tokenCheck);
                }
                if ((tokenStore = TokenStore.getTokenStore(context.getSession(false))) == null) {
                    this.tokenError(tokenCheck);
                }
                try {
                    isValid = tokenCheck.isUseFixedToken() ? tokenStore.isValidFixed(token) : tokenStore.isValid(token, tokenCheck.isConsume());
                    if (!isValid) {
                        this.tokenError(tokenCheck);
                    }
                    return invocation.proceedCommand();
                }
                catch (RuntimeException e) {
                    if (isValid && !tokenCheck.isUseFixedToken() && tokenCheck.isExceptionRollback() && tokenCheck.isConsume()) {
                        tokenStore.pushBack(token);
                    }
                    throw e;
                }
            }
        }
        return invocation.proceedCommand();
    }

    private void tokenError(MetaWebApiTokenCheck tokenCheck) {
        throw new TokenValidationException(TokenInterceptor.resourceString("impl.web.interceptors.TokenInterceptor.invalidErr", new Object[0]));
    }

    private static String resourceString(String key, Object ... arguments) {
        return WebResourceBundleUtil.resourceString(key, arguments);
    }
}

