/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.webapi.interceptors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.command.interceptor.CommandInvocation;
import org.iplass.mtp.impl.command.InterceptorService;
import org.iplass.mtp.impl.web.WebRequestStack;
import org.iplass.mtp.impl.web.interceptors.ExceptionInterceptor;
import org.iplass.mtp.impl.webapi.rest.RestRequestContext;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;
import org.iplass.mtp.webapi.definition.MethodType;
import org.iplass.mtp.webapi.definition.RequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggingInterceptor
extends org.iplass.mtp.impl.command.interceptors.LoggingInterceptor
implements ServiceInitListener<InterceptorService> {
    private static Logger webapiLogger = LoggerFactory.getLogger((String)"mtp.webapi");
    private static final String MDC_WEBAPI = "webapi";
    private boolean webapiTrace = true;
    private List<String> noStackTrace;
    private List<Class<?>[]> noStackTraceClass;
    private List<String> logParamName;
    private List<String> logAttributeName;

    public List<String> getLogParamName() {
        return this.logParamName;
    }

    public void setLogParamName(List<String> logParamName) {
        this.logParamName = logParamName;
    }

    public List<String> getLogAttributeName() {
        return this.logAttributeName;
    }

    public void setLogAttributeName(List<String> logAttributeName) {
        this.logAttributeName = logAttributeName;
    }

    public boolean isWebapiTrace() {
        return this.webapiTrace;
    }

    public void setWebapiTrace(boolean webapiTrace) {
        this.webapiTrace = webapiTrace;
    }

    public List<String> getNoStackTrace() {
        return this.noStackTrace;
    }

    public void setNoStackTrace(List<String> noStackTrace) {
        this.noStackTrace = noStackTrace;
    }

    public void inited(InterceptorService service, Config config) {
        if (this.noStackTrace != null) {
            this.noStackTraceClass = ExceptionInterceptor.toClassList(this.noStackTrace);
        }
    }

    public void destroyed() {
    }

    public String intercept(CommandInvocation invocation) {
        long start = -1L;
        if (this.webapiTrace) {
            start = System.currentTimeMillis();
        }
        String webApiName = (String)invocation.getRequest().getAttribute("webApiName");
        MDC.put((String)MDC_WEBAPI, (String)webApiName);
        RuntimeException exp = null;
        try {
            String string = super.intercept(invocation);
            return string;
        }
        catch (RuntimeException t) {
            exp = t;
            throw t;
        }
        finally {
            if (exp != null && !(exp instanceof ApplicationException)) {
                if (this.webapiTrace) {
                    if (ExceptionInterceptor.match(this.noStackTraceClass, exp)) {
                        webapiLogger.error(this.makeWebApiName((RestRequestContext)invocation.getRequest()) + "," + (System.currentTimeMillis() - start) + "ms,Error," + exp.toString());
                    } else {
                        webapiLogger.error(this.makeWebApiName((RestRequestContext)invocation.getRequest()) + "," + (System.currentTimeMillis() - start) + "ms,Error," + exp.toString(), (Throwable)exp);
                    }
                } else if (ExceptionInterceptor.match(this.noStackTraceClass, exp)) {
                    webapiLogger.error(this.makeWebApiName((RestRequestContext)invocation.getRequest()) + ",Error," + exp.toString());
                } else {
                    webapiLogger.error(this.makeWebApiName((RestRequestContext)invocation.getRequest()) + ",Error," + exp.toString(), (Throwable)exp);
                }
            } else if (this.webapiTrace) {
                if (exp != null) {
                    webapiLogger.info(this.makeWebApiName((RestRequestContext)invocation.getRequest()) + "," + (System.currentTimeMillis() - start) + "ms,AppError," + exp.toString());
                } else {
                    webapiLogger.info(this.makeWebApiName((RestRequestContext)invocation.getRequest()) + "," + (System.currentTimeMillis() - start) + "ms");
                }
            }
            MDC.remove((String)MDC_WEBAPI);
        }
    }

    private String makeWebApiName(RestRequestContext req) {
        String webApiName = WebRequestStack.getCurrent().getRequestPath().getTargetPath(true);
        RequestType requestType = req.requestType();
        MethodType methodType = req.methodType();
        StringBuilder sb = new StringBuilder();
        sb.append(webApiName);
        if (req != null) {
            Object val;
            boolean isFirst;
            if (this.getLogParamName() != null) {
                isFirst = true;
                for (String p : this.getLogParamName()) {
                    val = req.getParam(p);
                    if (val == null) continue;
                    if (isFirst) {
                        sb.append("?");
                        isFirst = false;
                    } else {
                        sb.append("&");
                    }
                    if (val instanceof String[]) {
                        String[] valArray = (String[])val;
                        for (int i = 0; i < valArray.length; ++i) {
                            if (i != 0) {
                                sb.append("&");
                            }
                            sb.append(p).append("=").append(valArray[i]);
                        }
                        continue;
                    }
                    sb.append(p).append("=").append(val);
                }
            }
            if (this.getLogAttributeName() != null) {
                sb.append("[");
                isFirst = true;
                for (String p : this.getLogAttributeName()) {
                    val = req.getAttribute(p);
                    if (val == null) continue;
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(p).append("=");
                    if (val instanceof Object[]) {
                        sb.append(Arrays.toString((Object[])val));
                        continue;
                    }
                    if (val instanceof Map) {
                        this.appendMap(sb, (Map)val, null);
                        continue;
                    }
                    sb.append(val);
                }
                sb.append("]");
            }
        }
        sb.append("(").append((Object)requestType).append("/").append((Object)methodType).append(")");
        return sb.toString();
    }

    private void appendMap(StringBuilder sb, Map map, HashSet<Map> looped) {
        Iterator i = map.entrySet().iterator();
        if (!i.hasNext()) {
            sb.append("{}");
            return;
        }
        sb.append('{');
        while (true) {
            Map.Entry e = i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            sb.append((Object)(key == map ? "(this Map)" : key));
            sb.append('=');
            if (value == map) {
                sb.append("(this Map)");
            } else if (value instanceof Object[]) {
                sb.append(Arrays.deepToString((Object[])value));
            } else if (value instanceof Map) {
                if (looped == null) {
                    looped = new HashSet();
                }
                looped.add(map);
                if (looped.contains(value)) {
                    sb.append("(looped Map)");
                } else {
                    this.appendMap(sb, (Map)value, looped);
                }
            } else {
                sb.append(value);
            }
            if (!i.hasNext()) {
                sb.append('}');
                return;
            }
            sb.append(',').append(' ');
        }
    }
}

