/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web.actionmapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.annotation.CommandClass;
import org.iplass.mtp.command.annotation.action.ActionMapping;
import org.iplass.mtp.command.annotation.action.ParamMapping;
import org.iplass.mtp.command.annotation.action.Result;
import org.iplass.mtp.command.annotation.action.cache.CacheCriteria;
import org.iplass.mtp.command.annotation.action.cache.CacheRelatedEntity;
import org.iplass.mtp.definition.annotation.LocalizedString;
import org.iplass.mtp.impl.command.MetaCommandFactory;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.metadata.annotation.AnnotatableMetaDataFactory;
import org.iplass.mtp.impl.metadata.annotation.AnnotateMetaDataEntry;
import org.iplass.mtp.impl.web.WebFrontendService;
import org.iplass.mtp.impl.web.actionmapping.DynamicTemplateResult;
import org.iplass.mtp.impl.web.actionmapping.MetaActionMapping;
import org.iplass.mtp.impl.web.actionmapping.MetaTokenCheck;
import org.iplass.mtp.impl.web.actionmapping.ParamMap;
import org.iplass.mtp.impl.web.actionmapping.RedirectResult;
import org.iplass.mtp.impl.web.actionmapping.Result;
import org.iplass.mtp.impl.web.actionmapping.StreamResult;
import org.iplass.mtp.impl.web.actionmapping.TemplateResult;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheCriteria;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaCacheRelatedEntity;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaJavaClassCacheCriteria;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaParameterMatchCacheCriteria;
import org.iplass.mtp.impl.web.actionmapping.cache.MetaScriptingCacheCriteria;
import org.iplass.mtp.impl.web.template.MetaJspTemplate;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.util.StringUtil;
import org.iplass.mtp.web.actionmapping.ActionCacheCriteria;
import org.iplass.mtp.web.actionmapping.definition.ClientCacheType;
import org.iplass.mtp.web.actionmapping.definition.HttpMethodType;

public class MetaActionMappingFactory
implements AnnotatableMetaDataFactory<ActionMapping, Command> {
    private MetaCommandFactory commandFactory = new MetaCommandFactory();

    public Class<Command> getAnnotatedClass() {
        return Command.class;
    }

    public Class<ActionMapping> getAnnotationClass() {
        return ActionMapping.class;
    }

    private Result toMetaResult(String actionMappingPath, org.iplass.mtp.command.annotation.action.Result result, Map<String, AnnotateMetaDataEntry> map, boolean overwritable) {
        Result r = null;
        switch (result.type()) {
            case JSP: {
                MetaJspTemplate template = new MetaJspTemplate();
                String jspPath = result.value();
                template.setPath(jspPath);
                if ("##default".equals(result.templateName())) {
                    if (jspPath.startsWith("/")) {
                        template.setName(jspPath.substring(1));
                    } else {
                        template.setName(jspPath);
                    }
                } else {
                    template.setName(result.templateName());
                }
                String metaPath = "/template/" + template.getName();
                template.setId(metaPath);
                if ("##default".equals(result.contentType())) {
                    template.setContentType(((WebFrontendService)ServiceRegistry.getRegistry().getService(WebFrontendService.class)).getDefaultContentType());
                } else {
                    template.setContentType(result.contentType());
                }
                map.put(metaPath, new AnnotateMetaDataEntry((RootMetaData)template, overwritable, false));
                TemplateResult tr = new TemplateResult(null, metaPath);
                tr.setUseContentDisposition(result.useContentDisposition());
                tr.setContentDispositionType(result.contentDispositionType());
                tr.setFileNameAttributeName(result.fileNameAttributeName());
                if (StringUtil.isNotEmpty((String)result.layoutActionName())) {
                    tr.setLayoutName(result.layoutActionName());
                    tr.setLayoutResolveByName(true);
                }
                r = tr;
                break;
            }
            case TEMPLATE: {
                TemplateResult tr = new TemplateResult(null, result.resolveByName(), result.value());
                tr.setUseContentDisposition(result.useContentDisposition());
                tr.setContentDispositionType(result.contentDispositionType());
                tr.setFileNameAttributeName(result.fileNameAttributeName());
                if (StringUtil.isNotEmpty((String)result.layoutActionName())) {
                    tr.setLayoutName(result.layoutActionName());
                    tr.setLayoutResolveByName(true);
                }
                r = tr;
                break;
            }
            case DYNAMIC: {
                String templatePathAttributeName = "##default".equals(result.value()) ? "templateName" : result.value();
                DynamicTemplateResult dtr = new DynamicTemplateResult(null, templatePathAttributeName);
                dtr.setUseContentDisposition(result.useContentDisposition());
                dtr.setContentDispositionType(result.contentDispositionType());
                dtr.setFileNameAttributeName(result.fileNameAttributeName());
                String layoutActionAttributeName = "##default".equals(result.layoutActionAttributeName()) ? "layoutActionName" : result.layoutActionAttributeName();
                dtr.setLayoutActionAttributeName(layoutActionAttributeName);
                r = dtr;
                break;
            }
            case REDIRECT: {
                r = new RedirectResult(null, result.value(), result.allowExternalLocation());
                break;
            }
            case STREAM: {
                String inputStreamAttributeName = "##default".equals(result.value()) ? "streamData" : result.value();
                StreamResult sr = new StreamResult(null, inputStreamAttributeName);
                if (!"##default".equals(result.contentTypeAttributeName())) {
                    sr.setContentTypeAttributeName(result.contentTypeAttributeName());
                }
                if (!"##default".equals(result.contentLengthAttributeName())) {
                    sr.setContentLengthAttributeName(result.contentLengthAttributeName());
                }
                sr.setUseContentDisposition(result.useContentDisposition());
                sr.setContentDispositionType(result.contentDispositionType());
                sr.setFileNameAttributeName(result.fileNameAttributeName());
                sr.setAcceptRanges(result.acceptRanges());
                r = sr;
                break;
            }
            default: {
                r = null;
            }
        }
        if (r != null) {
            if (result.exception() != Result.UNSPECIFIED.class) {
                r.setExceptionClassName(result.exception().getName());
            }
            if ("##default".equals(result.status())) {
                if (result.exception() == Result.UNSPECIFIED.class) {
                    r.setCommandResultStatus("*");
                }
            } else {
                r.setCommandResultStatus(result.status());
            }
        }
        return r;
    }

    private MetaCacheCriteria toMetaCacheCriteria(CacheCriteria anoCacheCriteria) {
        MetaCacheCriteria criteria = null;
        switch (anoCacheCriteria.type()) {
            case JAVA_CLASS: {
                if (anoCacheCriteria.javaCriteriaClass() != ActionCacheCriteria.class) {
                    MetaJavaClassCacheCriteria javaCriteria = new MetaJavaClassCacheCriteria();
                    javaCriteria.setClassName(anoCacheCriteria.javaCriteriaClass().getName());
                    criteria = javaCriteria;
                    break;
                }
                return null;
            }
            case PARAMETER_MATCH: {
                MetaParameterMatchCacheCriteria paramCriteria = new MetaParameterMatchCacheCriteria();
                paramCriteria.setMatchingParameterName(Arrays.asList(anoCacheCriteria.matchingParameterName()));
                criteria = paramCriteria;
                break;
            }
            case SCRIPTING: {
                MetaScriptingCacheCriteria scriptCriteria = new MetaScriptingCacheCriteria();
                scriptCriteria.setScript(anoCacheCriteria.scriptCriteria());
                criteria = scriptCriteria;
                break;
            }
            default: {
                return null;
            }
        }
        if (anoCacheCriteria.cachableResultStatus().length > 0) {
            criteria.setCachableCommandResultStatus(Arrays.asList(anoCacheCriteria.cachableResultStatus()));
        }
        if (anoCacheCriteria.cacheRelatedEntity().length > 0) {
            ArrayList<MetaCacheRelatedEntity> entities = new ArrayList<MetaCacheRelatedEntity>();
            for (CacheRelatedEntity anoEntity : anoCacheCriteria.cacheRelatedEntity()) {
                MetaCacheRelatedEntity entity = new MetaCacheRelatedEntity();
                entity.setDefinitionName(anoEntity.definitionName());
                entity.setType(anoEntity.type());
                entities.add(entity);
            }
            criteria.setRelatedEntity(entities);
        }
        if (anoCacheCriteria.timeToLive() >= 0) {
            criteria.setTimeToLive(anoCacheCriteria.timeToLive());
        }
        return criteria;
    }

    Map<String, AnnotateMetaDataEntry> toMetaData(ActionMapping actionMapping, Class<Command> annotatedClass) {
        MetaCommandFactory.MetaCommandResult res;
        CommandClass classDef;
        HashMap<String, AnnotateMetaDataEntry> map = new HashMap<String, AnnotateMetaDataEntry>();
        MetaActionMapping metaActionMapping = new MetaActionMapping();
        String path = "/action/" + actionMapping.name();
        metaActionMapping.setName(actionMapping.name());
        if (!"##default".equals(actionMapping.id())) {
            metaActionMapping.setId(actionMapping.id());
        } else {
            metaActionMapping.setId(path);
        }
        if (!"##default".equals(actionMapping.displayName())) {
            metaActionMapping.setDisplayName(actionMapping.displayName());
        } else {
            classDef = annotatedClass.getAnnotation(CommandClass.class);
            if (!"##default".equals(classDef.displayName())) {
                metaActionMapping.setDisplayName(classDef.displayName());
            }
        }
        if (actionMapping.localizedDisplayName().length > 0) {
            ArrayList<MetaLocalizedString> localizedDisplayNameList = new ArrayList<MetaLocalizedString>();
            for (LocalizedString localeValue : actionMapping.localizedDisplayName()) {
                MetaLocalizedString metaLocaleValue = new MetaLocalizedString();
                metaLocaleValue.setLocaleName(localeValue.localeName());
                metaLocaleValue.setStringValue(localeValue.stringValue());
                localizedDisplayNameList.add(metaLocaleValue);
            }
            metaActionMapping.setLocalizedDisplayNameList(localizedDisplayNameList);
        } else {
            classDef = annotatedClass.getAnnotation(CommandClass.class);
            if (classDef.localizedDisplayName().length > 0) {
                ArrayList<MetaLocalizedString> localizedDisplayNameList = new ArrayList<MetaLocalizedString>();
                for (LocalizedString localeValue : classDef.localizedDisplayName()) {
                    MetaLocalizedString metaLocaleValue = new MetaLocalizedString();
                    metaLocaleValue.setLocaleName(localeValue.localeName());
                    metaLocaleValue.setStringValue(localeValue.stringValue());
                    localizedDisplayNameList.add(metaLocaleValue);
                }
                metaActionMapping.setLocalizedDisplayNameList(localizedDisplayNameList);
            }
        }
        if (!"##default".equals(actionMapping.description())) {
            metaActionMapping.setDescription(actionMapping.description());
        } else {
            classDef = annotatedClass.getAnnotation(CommandClass.class);
            if (!"##default".equals(classDef.description())) {
                metaActionMapping.setDescription(classDef.description());
            }
        }
        if (actionMapping.clientCacheType() != null) {
            switch (actionMapping.clientCacheType()) {
                case CACHE: {
                    metaActionMapping.setClientCacheType(ClientCacheType.CACHE);
                    break;
                }
                case NO_CACHE: {
                    metaActionMapping.setClientCacheType(ClientCacheType.NO_CACHE);
                    break;
                }
            }
        }
        metaActionMapping.setClientCacheMaxAge(actionMapping.clientCacheMaxAge());
        if (actionMapping.allowMethod().length > 0) {
            HttpMethodType[] allowMethods = new HttpMethodType[actionMapping.allowMethod().length];
            System.arraycopy(actionMapping.allowMethod(), 0, allowMethods, 0, allowMethods.length);
            metaActionMapping.setAllowMethod(allowMethods);
        }
        metaActionMapping.setNeedTrustedAuthenticate(actionMapping.needTrustedAuthenticate());
        metaActionMapping.setParts(actionMapping.parts());
        metaActionMapping.setPrivilaged(actionMapping.privilaged());
        metaActionMapping.setPublicAction(actionMapping.publicAction());
        if (actionMapping.paramMapping().length > 0) {
            ParamMap[] paramMap = new ParamMap[actionMapping.paramMapping().length];
            for (int i = 0; i < paramMap.length; ++i) {
                ParamMapping anoParamMap = actionMapping.paramMapping()[i];
                paramMap[i] = new ParamMap(anoParamMap.name(), anoParamMap.mapFrom());
                if ("##default".equals(anoParamMap.condition())) continue;
                paramMap[i].setCondition(anoParamMap.condition());
            }
            metaActionMapping.setParamMap(paramMap);
        }
        if ((res = this.commandFactory.toMetaCommand(actionMapping.compositeCommand(), annotatedClass)) == null) {
            res = this.commandFactory.toMetaCommand(actionMapping.command(), annotatedClass);
        }
        metaActionMapping.setCommand(res.metaCommand);
        Result[] metaResult = new Result[actionMapping.result().length];
        for (int i = 0; i < metaResult.length; ++i) {
            metaResult[i] = this.toMetaResult(actionMapping.name(), actionMapping.result()[i], map, actionMapping.overwritable());
        }
        metaActionMapping.setResult(metaResult);
        if (actionMapping.tokenCheck().executeCheck()) {
            MetaTokenCheck tokenCheck = new MetaTokenCheck();
            tokenCheck.setConsume(actionMapping.tokenCheck().consume());
            tokenCheck.setExceptionRollback(actionMapping.tokenCheck().exceptionRollback());
            tokenCheck.setUseFixedToken(actionMapping.tokenCheck().useFixedToken());
            metaActionMapping.setTokenCheck(tokenCheck);
        }
        if (!CacheCriteria.Type.NO_CACHE.equals((Object)actionMapping.cacheCriteria().type())) {
            MetaCacheCriteria cacheCriteria = this.toMetaCacheCriteria(actionMapping.cacheCriteria());
            metaActionMapping.setCacheCriteria(cacheCriteria);
        }
        metaActionMapping.setSynchronizeOnSession(actionMapping.synchronizeOnSession());
        map.put(path, new AnnotateMetaDataEntry((RootMetaData)metaActionMapping, actionMapping.overwritable(), actionMapping.permissionSharable()));
        return map;
    }

    public Map<String, AnnotateMetaDataEntry> toMetaData(Class<Command> annotatedClass) {
        ActionMapping actionMapping = annotatedClass.getAnnotation(ActionMapping.class);
        return this.toMetaData(actionMapping, annotatedClass);
    }
}

