/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.web;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.iplass.mtp.impl.async.rdb.RdbQueueService;
import org.iplass.mtp.impl.cache.store.builtin.CacheEntryCleaner;
import org.iplass.mtp.impl.core.config.ServiceRegistryInitializer;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInitializer
implements ServletContextListener {
    private static Logger logger = LoggerFactory.getLogger(ApplicationInitializer.class);

    public void contextDestroyed(ServletContextEvent event) {
        logger.info("destroy all service");
        ServiceRegistry.getRegistry().destroyAllService();
        CacheEntryCleaner.shutdown();
        ILoggerFactory lf = LoggerFactory.getILoggerFactory();
        try {
            Method stopMethod;
            Class<?> logbackLoggerContextClass = Class.forName("ch.qos.logback.classic.LoggerContext");
            if (logbackLoggerContextClass.isAssignableFrom(lf.getClass()) && (stopMethod = logbackLoggerContextClass.getMethod("stop", new Class[0])) != null) {
                stopMethod.invoke((Object)lf, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void contextInitialized(ServletContextEvent e) {
        ServiceRegistry sr;
        String cryptConfigFileName;
        String serviceConfigFileName;
        ServletContext sc = e.getServletContext();
        String serverEnvFileName = sc.getInitParameter("mtp.server.env");
        if (serverEnvFileName != null) {
            logger.info("use " + serverEnvFileName + " as ServerEnvFile.");
            ServiceRegistryInitializer.setServerEnvFileName((String)serverEnvFileName);
        }
        if ((serviceConfigFileName = sc.getInitParameter("mtp.config")) != null) {
            boolean isFinalServiceConfig = Boolean.parseBoolean(sc.getInitParameter("mtp.config.isfinal"));
            if (!ServiceRegistryInitializer.isSetConfigFileName() || !isFinalServiceConfig) {
                logger.info("initialize with config:" + serviceConfigFileName);
                ServiceRegistryInitializer.setConfigFileName((String)serviceConfigFileName);
            }
        }
        if ((cryptConfigFileName = sc.getInitParameter("mtp.config.crypt")) != null) {
            logger.debug("use cryptConfigFile:" + cryptConfigFileName);
            ServiceRegistryInitializer.setCryptoConfigFileName((String)cryptConfigFileName);
        }
        if ((sr = ServiceRegistry.getRegistry()).exists(RdbQueueService.class)) {
            RdbQueueService rdbQueueService = (RdbQueueService)sr.getService(RdbQueueService.class);
        }
    }
}

