/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.oauth.token.opaque;

import java.io.Serializable;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.impl.auth.oauth.MetaOAuthClient;
import org.iplass.mtp.impl.auth.oauth.token.opaque.OAuthServiceHolder;

class RefreshTokenMement
implements Serializable {
    private static final long serialVersionUID = 7426470500545040379L;
    private String clientMetaDataId;
    private long expires;
    private String userUniqueId;

    RefreshTokenMement() {
    }

    void save(RefreshTokenInfo info, long expires, String userUniqueId) {
        MetaOAuthClient.OAuthClientRuntime client = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeByName(info.getClientName());
        this.clientMetaDataId = client.getMetaData().getId();
        this.expires = expires;
        this.userUniqueId = userUniqueId;
    }

    public String getClientMetaDataId() {
        return this.clientMetaDataId;
    }

    long getExpires() {
        return this.expires;
    }

    String getUserUniqueId() {
        return this.userUniqueId;
    }

    void fill(RefreshTokenInfo info) {
        MetaOAuthClient.OAuthClientRuntime ocr = (MetaOAuthClient.OAuthClientRuntime)OAuthServiceHolder.client.getRuntimeById(this.clientMetaDataId);
        if (ocr != null) {
            info.setClientName(ocr.getMetaData().getName());
        }
    }

    static class RefreshTokenInfo
    implements AuthTokenInfo {
        private String type;
        private String key;
        private String clientName;

        public RefreshTokenInfo() {
        }

        public RefreshTokenInfo(String clientName) {
            this.clientName = clientName;
        }

        public String getClientName() {
            return this.clientName;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            sb.append("OAuth2.0 Refresh Token for client:" + this.clientName);
            return sb.toString();
        }
    }
}

